/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler.byteCode;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ParameterizedType {
    private final String type;
    private final String className;
    private final List<String> parameters;

    public static ParameterizedType type(String className) {
        return new ParameterizedType(className);
    }

    public static ParameterizedType type(Class<?> type) {
        return new ParameterizedType(type);
    }

    public static ParameterizedType type(Class<?> type, Class<?> ... parameters) {
        return new ParameterizedType(type, parameters);
    }

    public static ParameterizedType type(Class<?> type, ParameterizedType ... parameters) {
        return new ParameterizedType(type, parameters);
    }

    public ParameterizedType(String className) {
        this.className = className;
        this.type = "L" + className + ";";
        this.parameters = ImmutableList.of();
    }

    private ParameterizedType(Class<?> type) {
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        this.parameters = ImmutableList.of();
    }

    private ParameterizedType(Class<?> type, Class<?> ... parameters) {
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> parameter : parameters) {
            builder.add((Object)ParameterizedType.toInternalIdentifier(parameter));
        }
        this.parameters = builder.build();
    }

    private ParameterizedType(Class<?> type, ParameterizedType ... parameters) {
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ParameterizedType parameter : parameters) {
            builder.add((Object)parameter.toString());
        }
        this.parameters = builder.build();
    }

    public String getClassName() {
        return this.className;
    }

    public String getType() {
        return this.type;
    }

    public String getGenericSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append('L').append(this.className);
        if (!this.parameters.isEmpty()) {
            sb.append("<");
            for (String parameterType : this.parameters) {
                sb.append(parameterType);
            }
            sb.append(">");
        }
        sb.append(";");
        return sb.toString();
    }

    public boolean isGeneric() {
        return !this.parameters.isEmpty();
    }

    public String toString() {
        return this.getGenericSignature();
    }

    public static String getPathName(Class<?> n) {
        return n.getName().replace('.', '/');
    }

    private static String toInternalIdentifier(Class<?> n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Short.TYPE) {
                    return "[S";
                }
                if (n == Character.TYPE) {
                    return "[C";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Float.TYPE) {
                    return "[F";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + ParameterizedType.toInternalIdentifier(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Short.TYPE) {
                return "S";
            }
            if (n == Character.TYPE) {
                return "C";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Float.TYPE) {
                return "F";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + ParameterizedType.getPathName(n) + ";";
    }

    public static Predicate<ParameterizedType> isGenericType() {
        return new Predicate<ParameterizedType>(){

            public boolean apply(ParameterizedType input) {
                return input.isGeneric();
            }
        };
    }

    public static Function<ParameterizedType, String> getParameterType() {
        return new Function<ParameterizedType, String>(){

            public String apply(ParameterizedType input) {
                return input.getType();
            }
        };
    }

    public static Function<Class<?>, ParameterizedType> toParameterizedType() {
        return new Function<Class<?>, ParameterizedType>(){

            public ParameterizedType apply(@Nullable Class<?> input) {
                return new ParameterizedType((Class)input);
            }
        };
    }
}

