/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftEnum;
import com.facebook.swift.codec.metadata.ThriftEnumMetadata;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ThriftEnumMetadataBuilder<T extends Enum<T>> {
    private final Class<T> enumClass;
    private final String enumName;

    public ThriftEnumMetadataBuilder(Class<T> enumClass) {
        this.enumClass = enumClass;
        this.enumName = this.extractEnumName(enumClass);
    }

    public ThriftEnumMetadata<T> build() {
        return new ThriftEnumMetadata<T>(this.enumName, this.enumClass);
    }

    private String extractEnumName(Class<T> enumClass) {
        ThriftEnum annotation = enumClass.getAnnotation(ThriftEnum.class);
        if (annotation == null) {
            return enumClass.getSimpleName();
        }
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return enumClass.getSimpleName();
    }
}

