/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftConstructor;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.metadata.MetadataErrors;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ThriftStructMetadataBuilder<T> {
    private final String structName;
    private final Class<T> structClass;
    private final Class<?> builderClass;
    private final List<String> documentation;
    private final List<FieldMetadata> fields = Lists.newArrayList();
    private final List<Extractor> extractors = Lists.newArrayList();
    private final List<MethodInjection> builderMethodInjections = Lists.newArrayList();
    private final List<ConstructorInjection> constructorInjections = Lists.newArrayList();
    private final List<FieldInjection> fieldInjections = Lists.newArrayList();
    private final List<MethodInjection> methodInjections = Lists.newArrayList();
    private final ThriftCatalog catalog;
    private final MetadataErrors metadataErrors;

    public ThriftStructMetadataBuilder(ThriftCatalog catalog, Class<T> structClass) {
        this.catalog = (ThriftCatalog)Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        this.structClass = (Class)Preconditions.checkNotNull(structClass, (Object)"structClass is null");
        this.metadataErrors = new MetadataErrors(catalog.getMonitor());
        this.verifyStructClass();
        this.structName = this.extractStructName();
        this.builderClass = this.extractBuilderClass();
        this.documentation = ThriftCatalog.getThriftDocumentation(structClass);
        this.extractFromConstructors();
        this.extractFromFields();
        this.extractFromMethods();
        this.normalizeThriftFields(catalog);
    }

    public MetadataErrors getMetadataErrors() {
        return this.metadataErrors;
    }

    private void verifyStructClass() {
        if (Modifier.isAbstract(this.structClass.getModifiers())) {
            this.metadataErrors.addError("Struct class [%s] is abstract", this.structClass.getName());
        }
        if (!Modifier.isPublic(this.structClass.getModifiers())) {
            this.metadataErrors.addError("Struct class [%s] is not public", this.structClass.getName());
        }
        if (!this.structClass.isAnnotationPresent(ThriftStruct.class)) {
            this.metadataErrors.addError("Struct class [%s] does not have a @ThriftStruct annotation", this.structClass.getName());
        }
    }

    private String extractStructName() {
        ThriftStruct annotation = this.structClass.getAnnotation(ThriftStruct.class);
        if (annotation == null) {
            return this.structClass.getSimpleName();
        }
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return this.structClass.getSimpleName();
    }

    private Class<?> extractBuilderClass() {
        ThriftStruct annotation = this.structClass.getAnnotation(ThriftStruct.class);
        if (annotation != null && !annotation.builder().equals(Void.TYPE)) {
            return annotation.builder();
        }
        return null;
    }

    private void extractFromConstructors() {
        if (this.builderClass == null) {
            this.addConstructors(this.structClass);
        } else {
            this.addConstructors(this.builderClass);
            this.addBuilderMethods();
            for (Constructor<?> constructor : this.structClass.getConstructors()) {
                if (!constructor.isAnnotationPresent(ThriftConstructor.class)) continue;
                this.metadataErrors.addWarning("Struct class [%s] has a builder class, but constructor %s annotated with @ThriftConstructor", this.structClass.getName(), constructor);
            }
        }
    }

    private void addConstructors(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.isSynthetic() || !constructor.isAnnotationPresent(ThriftConstructor.class)) continue;
            if (!Modifier.isPublic(constructor.getModifiers())) {
                this.metadataErrors.addError("@ThriftConstructor [%s] is not public", constructor.toGenericString());
                continue;
            }
            List<ParameterInjection> parameters = this.getParameterInjections(constructor.getParameterAnnotations(), constructor.getGenericParameterTypes(), ReflectionHelper.extractParameterNames(constructor));
            if (parameters == null) continue;
            this.fields.addAll(parameters);
            this.constructorInjections.add(new ConstructorInjection(constructor, parameters));
        }
        if (this.constructorInjections.isEmpty()) {
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    this.metadataErrors.addError("Default constructor [%s] is not public", constructor.toGenericString());
                }
                this.constructorInjections.add(new ConstructorInjection(constructor, new ParameterInjection[0]));
            }
            catch (NoSuchMethodException e) {
                this.metadataErrors.addError("Struct class [%s] does not have a public no-arg constructor", clazz.getName());
            }
        }
        if (this.constructorInjections.size() > 1) {
            this.metadataErrors.addError("Multiple constructors are annotated with @ThriftConstructor ", this.constructorInjections);
        }
    }

    private void addBuilderMethods() {
        for (Method method : ReflectionHelper.findAnnotatedMethods(this.builderClass, ThriftConstructor.class)) {
            List<ParameterInjection> parameters = this.getParameterInjections(method.getParameterAnnotations(), method.getGenericParameterTypes(), ReflectionHelper.extractParameterNames(method));
            if (parameters == null) continue;
            this.fields.addAll(parameters);
            this.builderMethodInjections.add(new MethodInjection(method, parameters));
        }
        for (Method method : ReflectionHelper.getAllDeclaredMethods(this.builderClass)) {
            if (!method.isAnnotationPresent(ThriftConstructor.class) && !this.hasThriftFieldAnnotation(method)) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                this.metadataErrors.addError("@ThriftConstructor method [%s] is not public", method.toGenericString());
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftConstructor method [%s] is static", method.toGenericString());
        }
        if (this.builderMethodInjections.isEmpty()) {
            this.metadataErrors.addError("Struct builder class [%s] does not have a public builder method annotated with @ThriftConstructor", this.builderClass.getName());
        }
        if (this.builderMethodInjections.size() > 1) {
            this.metadataErrors.addError("Multiple builder methods are annotated with @ThriftConstructor ", this.builderMethodInjections);
        }
    }

    private void extractFromFields() {
        if (this.builderClass == null) {
            this.addFields(this.structClass, true, true);
        } else {
            this.addFields(this.builderClass, false, true);
            this.addFields(this.structClass, true, false);
        }
    }

    private void addFields(Class<?> clazz, boolean allowReaders, boolean allowWriters) {
        for (Field fieldField : ReflectionHelper.findAnnotatedFields(clazz, ThriftField.class)) {
            this.addField(fieldField, allowReaders, allowWriters);
        }
        for (Field field : ReflectionHelper.getAllDeclaredFields(clazz)) {
            if (!field.isAnnotationPresent(ThriftField.class)) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                this.metadataErrors.addError("@ThriftField field [%s] is not public", field.toGenericString());
            }
            if (!Modifier.isStatic(field.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftField field [%s] is static", field.toGenericString());
        }
    }

    private void addField(Field fieldField, boolean allowReaders, boolean allowWriters) {
        Preconditions.checkArgument((boolean)fieldField.isAnnotationPresent(ThriftField.class));
        ThriftField annotation = fieldField.getAnnotation(ThriftField.class);
        if (allowReaders) {
            FieldExtractor fieldExtractor = new FieldExtractor(fieldField, annotation);
            this.fields.add(fieldExtractor);
            this.extractors.add(fieldExtractor);
        }
        if (allowWriters) {
            FieldInjection fieldInjection = new FieldInjection(fieldField, annotation);
            this.fields.add(fieldInjection);
            this.fieldInjections.add(fieldInjection);
        }
    }

    private void extractFromMethods() {
        if (this.builderClass != null) {
            this.addMethods(this.builderClass, false, true);
            this.addMethods(this.structClass, true, false);
        } else {
            this.addMethods(this.structClass, true, true);
        }
    }

    private void addMethods(Class<?> clazz, boolean allowReaders, boolean allowWriters) {
        for (Method fieldMethod : ReflectionHelper.findAnnotatedMethods(clazz, ThriftField.class)) {
            this.addMethod(clazz, fieldMethod, allowReaders, allowWriters);
        }
        for (Method method : ReflectionHelper.getAllDeclaredMethods(clazz)) {
            if (!method.isAnnotationPresent(ThriftField.class) && !this.hasThriftFieldAnnotation(method)) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                this.metadataErrors.addError("@ThriftField method [%s] is not public", method.toGenericString());
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftField method [%s] is static", method.toGenericString());
        }
    }

    private void addMethod(Class<?> clazz, Method method, boolean allowReaders, boolean allowWriters) {
        Preconditions.checkArgument((boolean)method.isAnnotationPresent(ThriftField.class));
        ThriftField annotation = method.getAnnotation(ThriftField.class);
        if (this.isValidateGetter(method)) {
            if (allowReaders) {
                MethodExtractor methodExtractor = new MethodExtractor(method, annotation);
                this.fields.add(methodExtractor);
                this.extractors.add(methodExtractor);
            } else {
                this.metadataErrors.addError("Reader method %s.%s is not allowed on a builder class", clazz.getName(), method.getName());
            }
        } else if (this.isValidateSetter(method)) {
            if (allowWriters) {
                ImmutableList parameters;
                if (method.getParameterTypes().length > 1 || Iterables.any(Arrays.asList(method.getParameterAnnotations()[0]), (Predicate)Predicates.instanceOf(ThriftField.class))) {
                    parameters = this.getParameterInjections(method.getParameterAnnotations(), method.getGenericParameterTypes(), ReflectionHelper.extractParameterNames(method));
                    if (annotation.value() != Short.MIN_VALUE) {
                        this.metadataErrors.addError("A method with annotated parameters can not have a field id specified: %s.%s ", clazz.getName(), method.getName());
                    }
                    if (!annotation.name().isEmpty()) {
                        this.metadataErrors.addError("A method with annotated parameters can not have a field name specified: %s.%s ", clazz.getName(), method.getName());
                    }
                    if (annotation.required()) {
                        this.metadataErrors.addError("A method with annotated parameters can not be marked as required: %s.%s ", clazz.getName(), method.getName());
                    }
                } else {
                    parameters = ImmutableList.of((Object)new ParameterInjection(0, annotation, ThriftStructMetadataBuilder.extractFieldName(method), method.getGenericParameterTypes()[0]));
                }
                this.fields.addAll((Collection<FieldMetadata>)parameters);
                this.methodInjections.add(new MethodInjection(method, (List<ParameterInjection>)parameters));
            } else {
                this.metadataErrors.addError("Inject method %s.%s is not allowed on struct class, since struct has a builder", clazz.getName(), method.getName());
            }
        } else {
            this.metadataErrors.addError("Method %s.%s is not a supported getter or setter", clazz.getName(), method.getName());
        }
    }

    private boolean hasThriftFieldAnnotation(Method method) {
        Annotation[][] arr$ = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = arr$[i$]) {
                if (!(parameterAnnotation instanceof ThriftField)) continue;
                return true;
            }
        }
        return false;
    }

    private static String extractFieldName(Method method) {
        Preconditions.checkNotNull((Object)method, (Object)"method is null");
        return ThriftStructMetadataBuilder.extractFieldName(method.getName());
    }

    public static String extractFieldName(String methodName) {
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName is null");
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            String name = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            return name;
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            String name = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            return name;
        }
        return methodName;
    }

    private boolean isValidateGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    private boolean isValidateSetter(Method method) {
        return method.getParameterTypes().length >= 1;
    }

    private List<ParameterInjection> getParameterInjections(Annotation[][] parameterAnnotations, Type[] parameterTypes, String[] parameterNames) {
        ArrayList parameters = Lists.newArrayListWithCapacity((int)parameterAnnotations.length);
        for (int parameterIndex = 0; parameterIndex < parameterAnnotations.length; ++parameterIndex) {
            Annotation[] annotations = parameterAnnotations[parameterIndex];
            Type parameterType = parameterTypes[parameterIndex];
            ThriftField thriftField = null;
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof ThriftField)) continue;
                thriftField = (ThriftField)annotation;
            }
            ParameterInjection parameterInjection = new ParameterInjection(parameterIndex, thriftField, parameterNames[parameterIndex], parameterType);
            parameters.add(parameterInjection);
        }
        return parameters;
    }

    private void normalizeThriftFields(ThriftCatalog catalog) {
        Set<String> fieldsWithConflictingIds = this.inferThriftFieldIds();
        ImmutableListMultimap fieldsById = Multimaps.index(this.fields, FieldMetadata.getThriftFieldId());
        for (Map.Entry entry : fieldsById.asMap().entrySet()) {
            String fieldName2;
            Collection fields = (Collection)entry.getValue();
            if (!((Optional)entry.getKey()).isPresent()) {
                for (String fieldName2 : Sets.newTreeSet((Iterable)Iterables.transform((Iterable)fields, FieldMetadata.getOrExtractThriftFieldName()))) {
                    if (fieldsWithConflictingIds.contains(fieldName2)) continue;
                    this.metadataErrors.addError("ThriftStruct %s fields %s do not have an id", this.structName, Sets.newTreeSet((Iterable)Iterables.transform((Iterable)fields, FieldMetadata.getOrExtractThriftFieldName())));
                }
                continue;
            }
            short fieldId = (Short)((Optional)entry.getKey()).get();
            fieldName2 = this.extractFieldName(fieldId, fields);
            for (FieldMetadata field : fields) {
                field.setName(fieldName2);
            }
            this.verifyFieldType(fieldId, fieldName2, fields, catalog);
        }
    }

    private Set<String> inferThriftFieldIds() {
        HashSet<String> fieldsWithConflictingIds = new HashSet<String>();
        ImmutableListMultimap fieldsByExplicitOrExtractedName = Multimaps.index(this.fields, FieldMetadata.getOrExtractThriftFieldName());
        this.inferThriftFieldIds((Multimap<String, FieldMetadata>)fieldsByExplicitOrExtractedName, fieldsWithConflictingIds);
        ImmutableListMultimap fieldsByExtractedName = Multimaps.index(this.fields, FieldMetadata.extractThriftFieldName());
        this.inferThriftFieldIds((Multimap<String, FieldMetadata>)fieldsByExtractedName, fieldsWithConflictingIds);
        return fieldsWithConflictingIds;
    }

    private void inferThriftFieldIds(Multimap<String, FieldMetadata> fieldsByName, Set<String> fieldsWithConflictingIds) {
        for (Map.Entry entry : fieldsByName.asMap().entrySet()) {
            Collection fields = (Collection)entry.getValue();
            if (fields.size() <= 1) continue;
            ImmutableSet ids = ImmutableSet.copyOf((Iterable)Optional.presentInstances((Iterable)Iterables.transform((Iterable)fields, FieldMetadata.getThriftFieldId())));
            if (ids.size() > 1) {
                String fieldName = (String)entry.getKey();
                if (fieldsWithConflictingIds.contains(fieldName)) continue;
                this.metadataErrors.addError("ThriftStruct '%s' field '%s' has multiple ids: %s", this.structName, fieldName, ids);
                fieldsWithConflictingIds.add(fieldName);
                continue;
            }
            if (ids.size() != 1) continue;
            short id = (Short)Iterables.getOnlyElement((Iterable)ids);
            for (FieldMetadata field : fields) {
                field.setId(id);
            }
        }
    }

    private String extractFieldName(short id, Collection<FieldMetadata> fields) {
        String name;
        ImmutableSet names = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(fields, FieldMetadata.getThriftFieldName()), (Predicate)Predicates.notNull()));
        if (!names.isEmpty()) {
            if (names.size() > 1) {
                this.metadataErrors.addWarning("ThriftStruct %s field %s has multiple names %s", this.structName, id, names);
            }
            name = (String)names.iterator().next();
        } else {
            name = (String)Iterables.find((Iterable)Iterables.transform(fields, FieldMetadata.extractThriftFieldName()), (Predicate)Predicates.notNull());
        }
        return name;
    }

    private void verifyFieldType(short id, String name, Collection<FieldMetadata> fields, ThriftCatalog catalog) {
        boolean isSupportedType = true;
        for (FieldMetadata field : fields) {
            if (catalog.isSupportedStructFieldType(field.getJavaType())) continue;
            this.metadataErrors.addError("ThriftStruct %s field %s(%s) type %s is not a supported Java type", this.structName, name, id, TypeToken.of((Type)field.getJavaType()));
            isSupportedType = false;
            break;
        }
        if (isSupportedType) {
            HashSet<ThriftType> types = new HashSet<ThriftType>();
            for (FieldMetadata field : fields) {
                types.add(catalog.getThriftType(field.getJavaType()));
            }
            if (types.size() > 1) {
                this.metadataErrors.addWarning("ThriftStruct %s field %s(%s) has multiple types %s", this.structName, name, id, types);
            }
        }
    }

    public ThriftStructMetadata<T> build() {
        this.metadataErrors.throwIfHasErrors();
        ThriftMethodInjection builderMethodInjection = this.buildBuilderConstructorInjections();
        ThriftConstructorInjection constructorInjection = this.buildConstructorInjections();
        Iterable<ThriftFieldMetadata> fieldsMetadata = this.buildFieldInjections();
        List<ThriftMethodInjection> methodInjections = this.buildMethodInjections();
        return new ThriftStructMetadata<T>(this.structName, this.structClass, this.builderClass, builderMethodInjection, (List<String>)ImmutableList.copyOf(this.documentation), (List<ThriftFieldMetadata>)ImmutableList.copyOf(fieldsMetadata), constructorInjection, methodInjections);
    }

    private ThriftMethodInjection buildBuilderConstructorInjections() {
        ThriftMethodInjection builderMethodInjection = null;
        if (this.builderClass != null) {
            MethodInjection builderMethod = this.builderMethodInjections.get(0);
            builderMethodInjection = new ThriftMethodInjection(builderMethod.getMethod(), this.buildParameterInjections(builderMethod.getParameters()));
        }
        return builderMethodInjection;
    }

    private ThriftConstructorInjection buildConstructorInjections() {
        ConstructorInjection constructor = this.constructorInjections.get(0);
        return new ThriftConstructorInjection(constructor.getConstructor(), this.buildParameterInjections(constructor.getParameters()));
    }

    private Iterable<ThriftFieldMetadata> buildFieldInjections() {
        ImmutableListMultimap fieldsById = Multimaps.index(this.fields, FieldMetadata.getThriftFieldId());
        return Iterables.transform(fieldsById.asMap().values(), (Function)new Function<Collection<FieldMetadata>, ThriftFieldMetadata>(){

            public ThriftFieldMetadata apply(Collection<FieldMetadata> input) {
                Preconditions.checkArgument((!input.isEmpty() ? 1 : 0) != 0, (Object)"input is empty");
                return ThriftStructMetadataBuilder.this.buildField(input);
            }
        });
    }

    private ThriftFieldMetadata buildField(Collection<FieldMetadata> input) {
        short id = -1;
        String name = null;
        ThriftType type = null;
        ImmutableList.Builder injections = ImmutableList.builder();
        ThriftExtraction extraction = null;
        for (FieldMetadata fieldMetadata : input) {
            id = fieldMetadata.getId();
            name = fieldMetadata.getName();
            type = this.catalog.getThriftType(fieldMetadata.getJavaType());
            if (fieldMetadata instanceof FieldInjection) {
                FieldInjection fieldInjection = (FieldInjection)fieldMetadata;
                injections.add((Object)new ThriftFieldInjection(fieldInjection.getId(), fieldInjection.getName(), fieldInjection.getField()));
                continue;
            }
            if (fieldMetadata instanceof ParameterInjection) {
                ParameterInjection parameterInjection = (ParameterInjection)fieldMetadata;
                injections.add((Object)new ThriftParameterInjection(parameterInjection.getId(), parameterInjection.getName(), parameterInjection.getParameterIndex(), fieldMetadata.getJavaType()));
                continue;
            }
            if (fieldMetadata instanceof FieldExtractor) {
                FieldExtractor fieldExtractor = (FieldExtractor)fieldMetadata;
                extraction = new ThriftFieldExtractor(fieldExtractor.getId(), fieldExtractor.getName(), fieldExtractor.getField());
                continue;
            }
            if (!(fieldMetadata instanceof MethodExtractor)) continue;
            MethodExtractor methodExtractor = (MethodExtractor)fieldMetadata;
            extraction = new ThriftMethodExtractor(methodExtractor.getId(), methodExtractor.getName(), methodExtractor.getMethod());
        }
        TypeCoercion coercion = null;
        if (type.isCoerced()) {
            coercion = this.catalog.getDefaultCoercion(type.getJavaType());
        }
        ThriftFieldMetadata thriftFieldMetadata = new ThriftFieldMetadata(id, type, name, (List<ThriftInjection>)injections.build(), extraction, coercion);
        return thriftFieldMetadata;
    }

    private List<ThriftMethodInjection> buildMethodInjections() {
        return Lists.transform(this.methodInjections, (Function)new Function<MethodInjection, ThriftMethodInjection>(){

            public ThriftMethodInjection apply(MethodInjection injection) {
                return new ThriftMethodInjection(injection.getMethod(), ThriftStructMetadataBuilder.this.buildParameterInjections(injection.getParameters()));
            }
        });
    }

    private List<ThriftParameterInjection> buildParameterInjections(List<ParameterInjection> parameters) {
        return Lists.transform(parameters, (Function)new Function<ParameterInjection, ThriftParameterInjection>(){

            public ThriftParameterInjection apply(ParameterInjection injection) {
                return new ThriftParameterInjection(injection.getId(), injection.getName(), injection.getParameterIndex(), injection.getJavaType());
            }
        });
    }

    private static class ParameterInjection
    extends Injection {
        private final int parameterIndex;
        private final String extractedName;
        private final Type parameterJavaType;

        private ParameterInjection(int parameterIndex, ThriftField annotation, String extractedName, Type parameterJavaType) {
            super(annotation);
            Preconditions.checkNotNull((Object)parameterJavaType, (Object)"parameterJavaType is null");
            this.parameterIndex = parameterIndex;
            this.extractedName = extractedName;
            this.parameterJavaType = parameterJavaType;
            if (Void.TYPE.equals(parameterJavaType)) {
                throw new AssertionError();
            }
            Preconditions.checkArgument((this.getName() != null || extractedName != null ? 1 : 0) != 0, (Object)"Parameter must have an explicit name or an extractedName");
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        @Override
        public String extractName() {
            return this.extractedName;
        }

        @Override
        public Type getJavaType() {
            return this.parameterJavaType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ParameterInjection");
            sb.append("{parameterIndex=").append(this.parameterIndex);
            sb.append(", extractedName='").append(this.extractedName).append('\'');
            sb.append(", parameterJavaType=").append(this.parameterJavaType);
            sb.append('}');
            return sb.toString();
        }
    }

    public class MethodInjection {
        private final Method method;
        private final List<ParameterInjection> parameters;

        public MethodInjection(Method method, List<ParameterInjection> parameters) {
            this.method = method;
            this.parameters = ImmutableList.copyOf(parameters);
        }

        public Method getMethod() {
            return this.method;
        }

        public List<ParameterInjection> getParameters() {
            return this.parameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MethodInjection");
            sb.append("{method=").append(this.method);
            sb.append(", parameters=").append(this.parameters);
            sb.append('}');
            return sb.toString();
        }
    }

    public class ConstructorInjection {
        private final Constructor<?> constructor;
        private final List<ParameterInjection> parameters;

        public ConstructorInjection(Constructor<?> constructor, List<ParameterInjection> parameters) {
            this.constructor = constructor;
            this.parameters = ImmutableList.copyOf(parameters);
        }

        public ConstructorInjection(Constructor<?> constructor, ParameterInjection ... parameters) {
            this.constructor = constructor;
            this.parameters = ImmutableList.copyOf((Object[])parameters);
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public List<ParameterInjection> getParameters() {
            return this.parameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ConstructorInjection");
            sb.append("{constructor=").append(this.constructor);
            sb.append(", parameters=").append(this.parameters);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class FieldInjection
    extends Injection {
        private final Field field;

        private FieldInjection(Field field, ThriftField annotation) {
            super(annotation);
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }

        @Override
        public String extractName() {
            return this.field.getName();
        }

        @Override
        public Type getJavaType() {
            return this.field.getGenericType();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FieldInjection");
            sb.append("{field=").append(this.field);
            sb.append('}');
            return sb.toString();
        }
    }

    private static abstract class Injection
    extends FieldMetadata {
        protected Injection(ThriftField annotation) {
            super(annotation);
        }
    }

    public static class MethodExtractor
    extends Extractor {
        private final Method method;

        public MethodExtractor(Method method, ThriftField annotation) {
            super(annotation);
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public String extractName() {
            return ThriftStructMetadataBuilder.extractFieldName(this.method);
        }

        @Override
        public Type getJavaType() {
            return this.method.getGenericReturnType();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MethodExtractor");
            sb.append("{method=").append(this.method);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class FieldExtractor
    extends Extractor {
        private final Field field;

        private FieldExtractor(Field field, ThriftField annotation) {
            super(annotation);
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }

        @Override
        public String extractName() {
            return this.field.getName();
        }

        @Override
        public Type getJavaType() {
            return this.field.getGenericType();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FieldExtractor");
            sb.append("{field=").append(this.field);
            sb.append('}');
            return sb.toString();
        }
    }

    private static abstract class Extractor
    extends FieldMetadata {
        protected Extractor(ThriftField annotation) {
            super(annotation);
        }
    }

    static abstract class FieldMetadata {
        private Short id;
        private String name;

        private FieldMetadata(ThriftField annotation) {
            if (annotation != null) {
                if (annotation.value() != Short.MIN_VALUE) {
                    this.id = annotation.value();
                }
                if (!annotation.name().isEmpty()) {
                    this.name = annotation.name();
                }
            }
        }

        public Short getId() {
            return this.id;
        }

        public void setId(short id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public abstract Type getJavaType();

        public abstract String extractName();

        static <T extends FieldMetadata> Function<T, Optional<Short>> getThriftFieldId() {
            return new Function<T, Optional<Short>>(){

                public Optional<Short> apply(@Nullable T input) {
                    if (input == null) {
                        return Optional.absent();
                    }
                    Short value = ((FieldMetadata)input).getId();
                    return Optional.fromNullable((Object)value);
                }
            };
        }

        static <T extends FieldMetadata> Function<T, String> getThriftFieldName() {
            return new Function<T, String>(){

                public String apply(@Nullable T input) {
                    if (input == null) {
                        return null;
                    }
                    return ((FieldMetadata)input).getName();
                }
            };
        }

        static <T extends FieldMetadata> Function<T, String> getOrExtractThriftFieldName() {
            return new Function<T, String>(){

                public String apply(@Nullable T input) {
                    if (input == null) {
                        return null;
                    }
                    String name = ((FieldMetadata)input).getName();
                    if (name == null) {
                        name = ((FieldMetadata)input).extractName();
                    }
                    if (name == null) {
                        throw new NullPointerException(String.valueOf("name is null"));
                    }
                    return name;
                }
            };
        }

        static <T extends FieldMetadata> Function<T, String> extractThriftFieldName() {
            return new Function<T, String>(){

                public String apply(@Nullable T input) {
                    if (input == null) {
                        return null;
                    }
                    return ((FieldMetadata)input).extractName();
                }
            };
        }
    }
}

