/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator;

import com.facebook.swift.generator.ConstantRenderer;
import com.facebook.swift.generator.SwiftGeneratorConfig;
import com.facebook.swift.generator.SwiftGeneratorTweak;
import com.facebook.swift.generator.TypeRegistry;
import com.facebook.swift.generator.TypeToJavaConverter;
import com.facebook.swift.generator.TypedefRegistry;
import com.facebook.swift.generator.template.TemplateContextGenerator;
import com.facebook.swift.parser.ThriftIdlParser;
import com.facebook.swift.parser.model.Document;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;

public class SwiftDocumentContext {
    private final Document document;
    private final String namespace;
    private final SwiftGeneratorConfig generatorConfig;
    private final TypeRegistry typeRegistry;
    private final TypedefRegistry typedefRegistry;
    private final TypeToJavaConverter typeConverter;
    private final ConstantRenderer constantRenderer;
    private final URI thriftUri;

    public SwiftDocumentContext(URI thriftUri, String namespace, SwiftGeneratorConfig generatorConfig, TypeRegistry typeRegistry, TypedefRegistry typedefRegistry) throws IOException {
        this.document = ThriftIdlParser.parseThriftIdl((CharSource)Resources.asCharSource((URL)thriftUri.toURL(), (Charset)Charsets.UTF_8));
        this.thriftUri = thriftUri;
        this.namespace = namespace;
        this.generatorConfig = generatorConfig;
        this.typeRegistry = typeRegistry;
        this.typedefRegistry = typedefRegistry;
        this.typeConverter = new TypeToJavaConverter(typeRegistry, typedefRegistry, namespace, this.getJavaPackage());
        this.constantRenderer = new ConstantRenderer(this.typeConverter, namespace, typeRegistry, typedefRegistry);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Document getDocument() {
        return this.document;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public TypedefRegistry getTypedefRegistry() {
        return this.typedefRegistry;
    }

    public TypeToJavaConverter getTypeConverter() {
        return this.typeConverter;
    }

    public ConstantRenderer getConstantRenderer() {
        return this.constantRenderer;
    }

    public TemplateContextGenerator getTemplateContextGenerator() {
        return new TemplateContextGenerator(this.generatorConfig, this.typeRegistry, this.typeConverter, this.constantRenderer, this.namespace);
    }

    public String getJavaPackage() {
        String javaPackage;
        String effectiveJavaNamespace = "java.swift";
        if (this.generatorConfig.containsTweak(SwiftGeneratorTweak.USE_PLAIN_JAVA_NAMESPACE)) {
            effectiveJavaNamespace = "java";
        }
        if ((javaPackage = this.generatorConfig.getOverridePackage()) == null) {
            javaPackage = this.getDocument().getHeader().getNamespace(effectiveJavaNamespace);
        }
        if (javaPackage == null) {
            javaPackage = this.generatorConfig.getDefaultPackage();
        }
        Preconditions.checkState((javaPackage != null ? 1 : 0) != 0, (String)"thrift uri %s does not declare a '%s' namespace!", (Object[])new Object[]{this.thriftUri, effectiveJavaNamespace});
        return javaPackage;
    }
}

