/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator;

import com.facebook.swift.generator.SwiftDocumentContext;
import com.facebook.swift.generator.SwiftGeneratorConfig;
import com.facebook.swift.generator.SwiftJavaType;
import com.facebook.swift.generator.TypeRegistry;
import com.facebook.swift.generator.TypedefRegistry;
import com.facebook.swift.generator.util.SwiftInternalStringUtils;
import com.facebook.swift.generator.util.TemplateLoader;
import com.facebook.swift.generator.visitors.ConstantsVisitor;
import com.facebook.swift.generator.visitors.ExceptionVisitor;
import com.facebook.swift.generator.visitors.IntegerEnumVisitor;
import com.facebook.swift.generator.visitors.ServiceVisitor;
import com.facebook.swift.generator.visitors.StringEnumVisitor;
import com.facebook.swift.generator.visitors.StructVisitor;
import com.facebook.swift.generator.visitors.TypeVisitor;
import com.facebook.swift.generator.visitors.UnionVisitor;
import com.facebook.swift.parser.model.Document;
import com.facebook.swift.parser.model.Header;
import com.facebook.swift.parser.visitor.DocumentVisitor;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;

public class SwiftGenerator {
    private static final Logger LOG = Logger.get(SwiftGenerator.class);
    private static final Map<String, ImmutableList<String>> TEMPLATES = ImmutableMap.of((Object)"java-regular", (Object)ImmutableList.of((Object)"java/common.st", (Object)"java/regular.st"), (Object)"java-immutable", (Object)ImmutableList.of((Object)"java/common.st", (Object)"java/immutable.st"), (Object)"java-ctor", (Object)ImmutableList.of((Object)"java/common.st", (Object)"java/ctor.st"));
    private final File outputFolder;
    private final SwiftGeneratorConfig swiftGeneratorConfig;
    private final TemplateLoader templateLoader;
    private final Set<URI> parsedDocuments = new HashSet<URI>();
    private final Stack<URI> parentDocuments = new Stack();

    public SwiftGenerator(SwiftGeneratorConfig swiftGeneratorConfig) {
        Preconditions.checkState((TEMPLATES.get(swiftGeneratorConfig.getCodeFlavor()) != null ? 1 : 0) != 0, (String)"Templating type %s is unknown!", (Object[])new Object[]{swiftGeneratorConfig.getCodeFlavor()});
        this.swiftGeneratorConfig = swiftGeneratorConfig;
        this.outputFolder = swiftGeneratorConfig.getOutputFolder();
        if (this.outputFolder != null) {
            this.outputFolder.mkdirs();
        }
        LOG.debug("Writing source files into %s using %s ...", new Object[]{this.outputFolder, swiftGeneratorConfig.getCodeFlavor()});
        this.templateLoader = new TemplateLoader((Iterable)TEMPLATES.get(swiftGeneratorConfig.getCodeFlavor()));
    }

    public void parse(Iterable<URI> inputs) throws Exception {
        Preconditions.checkArgument((inputs != null && inputs.iterator().hasNext() ? 1 : 0) != 0, (Object)"No input files!");
        LOG.info("Parsing Thrift IDL from %s...", new Object[]{inputs});
        HashMap contexts = Maps.newHashMap();
        for (URI inputUri : inputs) {
            this.parsedDocuments.clear();
            this.parseDocument(inputUri.isAbsolute() ? inputUri : this.swiftGeneratorConfig.getInputBase().resolve(inputUri), contexts, new TypeRegistry(), new TypedefRegistry());
        }
        LOG.info("IDL parsing complete, writing java code...");
        for (SwiftDocumentContext context : contexts.values()) {
            this.generateFiles(context);
        }
        LOG.info("Java code generation complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDocument(URI thriftUri, @Nullable Map<String, SwiftDocumentContext> contexts, TypeRegistry typeRegistry, TypedefRegistry typedefRegistry) throws IOException {
        Preconditions.checkState((thriftUri != null && thriftUri.isAbsolute() && !thriftUri.isOpaque() ? 1 : 0) != 0, (Object)"Only absolute, non opaque URIs can be parsed!");
        Preconditions.checkArgument((!this.parentDocuments.contains(thriftUri) ? 1 : 0) != 0, (String)"Input %s recursively includes itself (%s)", (Object[])new Object[]{thriftUri, Joiner.on((String)" -> ").join(this.parentDocuments) + " -> " + thriftUri});
        if (this.parsedDocuments.contains(thriftUri)) {
            LOG.debug("Skipping already parsed file %s...", new Object[]{thriftUri});
            return;
        }
        LOG.debug("Parsing %s...", new Object[]{thriftUri});
        String thriftNamespace = this.extractThriftNamespace(thriftUri);
        Preconditions.checkState((!SwiftInternalStringUtils.isBlank(thriftNamespace) ? 1 : 0) != 0, (String)"Thrift URI %s can not be translated to a namespace", (Object[])new Object[]{thriftUri});
        SwiftDocumentContext context = new SwiftDocumentContext(thriftUri, thriftNamespace, this.swiftGeneratorConfig, typeRegistry, typedefRegistry);
        Document document = context.getDocument();
        Header header = document.getHeader();
        String javaPackage = context.getJavaPackage();
        typeRegistry.add(new SwiftJavaType(thriftNamespace, "Constants", "Constants", javaPackage));
        this.parentDocuments.push(thriftUri);
        try {
            for (String include : header.getIncludes()) {
                URI includeUri = this.swiftGeneratorConfig.getInputBase().resolve(include);
                LOG.debug("Found %s included from %s.", new Object[]{includeUri, thriftUri});
                this.parseDocument(includeUri, this.swiftGeneratorConfig.isGenerateIncludedCode() ? contexts : null, typeRegistry, typedefRegistry);
            }
        }
        finally {
            this.parentDocuments.pop();
        }
        this.parsedDocuments.add(thriftUri);
        document.visit((DocumentVisitor)new TypeVisitor(javaPackage, context));
        if (contexts != null && contexts.put(context.getNamespace(), context) != null) {
            LOG.info("Thrift Namespace %s included multiple times!", new Object[]{context.getNamespace()});
        }
    }

    private String extractThriftNamespace(URI thriftUri) {
        String path = thriftUri.getPath();
        String filename = (String)Iterables.getLast((Iterable)Splitter.on((char)'/').split((CharSequence)path), null);
        Preconditions.checkState((filename != null ? 1 : 0) != 0, (String)"No thrift namespace found in %s", (Object[])new Object[]{thriftUri});
        String name = (String)Iterables.getFirst((Iterable)Splitter.on((char)'.').split((CharSequence)filename), null);
        Preconditions.checkState((name != null ? 1 : 0) != 0, (String)"No thrift namespace found in %s", (Object[])new Object[]{thriftUri});
        return name;
    }

    private void generateFiles(SwiftDocumentContext context) throws IOException {
        LOG.debug("Generating code for %s...", new Object[]{context.getNamespace()});
        Preconditions.checkState((this.outputFolder != null ? 1 : 0) != 0, (Object)"The output folder was not set!");
        Preconditions.checkState((this.outputFolder.isDirectory() && this.outputFolder.canWrite() && this.outputFolder.canExecute() ? 1 : 0) != 0, (String)"output folder '%s' is not valid!", (Object[])new Object[]{this.outputFolder.getAbsolutePath()});
        ArrayList visitors = Lists.newArrayList();
        visitors.add(new ServiceVisitor(this.templateLoader, context, this.swiftGeneratorConfig, this.outputFolder));
        visitors.add(new StructVisitor(this.templateLoader, context, this.swiftGeneratorConfig, this.outputFolder));
        visitors.add(new UnionVisitor(this.templateLoader, context, this.swiftGeneratorConfig, this.outputFolder));
        visitors.add(new ExceptionVisitor(this.templateLoader, context, this.swiftGeneratorConfig, this.outputFolder));
        visitors.add(new IntegerEnumVisitor(this.templateLoader, context, this.swiftGeneratorConfig, this.outputFolder));
        visitors.add(new StringEnumVisitor(this.templateLoader, context, this.swiftGeneratorConfig, this.outputFolder));
        visitors.add(new ConstantsVisitor(this.templateLoader, context, this.swiftGeneratorConfig, this.outputFolder));
        for (DocumentVisitor visitor : visitors) {
            context.getDocument().visit(visitor);
            visitor.finish();
        }
    }
}

