/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator;

import com.facebook.swift.generator.SwiftJavaType;
import com.facebook.swift.generator.util.SwiftInternalStringUtils;
import com.facebook.swift.parser.model.ThriftType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;

public class TypedefRegistry
implements Iterable<Map.Entry<String, ThriftType>> {
    private final Map<String, ThriftType> registry = Maps.newHashMap();

    public void addAll(TypedefRegistry otherRegistry) {
        for (Map.Entry<String, ThriftType> entry : otherRegistry) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void add(SwiftJavaType type, ThriftType thriftType) {
        Preconditions.checkState((!this.registry.containsKey(type.getKey()) ? 1 : 0) != 0, (String)"The type %s was already registered!", (Object[])new Object[]{type});
        this.add(type.getKey(), thriftType);
    }

    private void add(String key, ThriftType thriftType) {
        Preconditions.checkArgument((!SwiftInternalStringUtils.isBlank(key) ? 1 : 0) != 0, (Object)"key can not be empty!");
        this.registry.put(key, thriftType);
    }

    public ThriftType findType(String defaultNamespace, String typeName) {
        String key = typeName;
        if (!key.contains(".")) {
            key = defaultNamespace + "." + typeName;
        }
        return this.findType(key);
    }

    public ThriftType findType(String key) {
        return this.registry.get(key);
    }

    @Override
    public Iterator<Map.Entry<String, ThriftType>> iterator() {
        return this.registry.entrySet().iterator();
    }
}

