/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.swift2thrift.template;

import com.facebook.swift.codec.metadata.ThriftType;
import java.util.Locale;
import java.util.Map;
import org.stringtemplate.v4.AttributeRenderer;

public class ThriftTypeRenderer
implements AttributeRenderer {
    private final Map<ThriftType, String> typenameMap;

    public ThriftTypeRenderer(Map<ThriftType, String> typenameMap) {
        this.typenameMap = typenameMap;
    }

    public String toString(Object o, String format, Locale locale) {
        return this.toString((ThriftType)o);
    }

    public String toString(ThriftType t) {
        switch (t.getProtocolType()) {
            case BOOL: {
                return "bool";
            }
            case BYTE: {
                return "byte";
            }
            case DOUBLE: {
                return "double";
            }
            case I16: {
                return "i16";
            }
            case I32: {
                return "i32";
            }
            case I64: {
                return "i64";
            }
            case ENUM: {
                return this.prefix(t) + t.getEnumMetadata().getEnumName();
            }
            case MAP: {
                return "map<" + this.toString(t.getKeyType()) + ", " + this.toString(t.getValueType()) + ">";
            }
            case SET: {
                return "set<" + this.toString(t.getValueType()) + ">";
            }
            case LIST: {
                return "list<" + this.toString(t.getValueType()) + ">";
            }
            case STRUCT: {
                return t.equals((Object)ThriftType.VOID) ? "void" : this.prefix(t) + t.getStructMetadata().getStructName();
            }
            case STRING: {
                return "string";
            }
            case BINARY: {
                return "binary";
            }
        }
        throw new IllegalStateException("Bad protocol type" + t.getProtocolType());
    }

    private String prefix(ThriftType t) {
        String result = this.typenameMap.get(t);
        return result == null ? "" : result + ".";
    }
}

