/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.util;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import io.airlift.log.Logger;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.STMessage;

public class TemplateLoader {
    private static final Function<String, CharSource> FILE_TO_INPUT_SUPPLIER_TRANSFORM = new Function<String, CharSource>(){

        @Nonnull
        public CharSource apply(@Nonnull String templateFileName) {
            return Resources.asCharSource((URL)Resources.getResource(this.getClass(), (String)("/templates/" + templateFileName)), (Charset)Charsets.UTF_8);
        }
    };
    private static final Logger LOG = Logger.get(TemplateLoader.class);
    private final STErrorListener ERROR_LISTENER = new ErrorListener();
    private final Iterable<String> templateFileNames;
    private volatile STGroup stg = null;
    private Map<Class<?>, ? extends AttributeRenderer> attributeRenderers = ImmutableMap.of();

    public TemplateLoader(Iterable<String> templateFileNames) {
        this.templateFileNames = templateFileNames;
    }

    public TemplateLoader(Iterable<String> templateFileNames, Map<Class<?>, ? extends AttributeRenderer> attributeRenderers) {
        this(templateFileNames);
        this.attributeRenderers = attributeRenderers;
    }

    public ST load(String templateName) throws IOException {
        STGroup stg = this.getTemplateGroup(this.templateFileNames);
        return stg.getInstanceOf(templateName);
    }

    protected STGroup getTemplateGroup(Iterable<String> templateFileNames) throws IOException {
        if (this.stg == null) {
            Iterable templateInputSuppliers = Iterables.transform(templateFileNames, FILE_TO_INPUT_SUPPLIER_TRANSFORM);
            this.stg = new STGroup();
            this.stg.setListener(this.ERROR_LISTENER);
            for (String string : templateFileNames) {
                this.stg.importTemplates(this.getTemplateGroupFromFile(string));
            }
            for (Map.Entry entry : this.attributeRenderers.entrySet()) {
                Class cls = (Class)entry.getKey();
                AttributeRenderer renderer = (AttributeRenderer)entry.getValue();
                this.stg.registerRenderer(cls, renderer);
            }
        }
        return this.stg;
    }

    protected STGroup getTemplateGroupFromFile(String fileName) throws IOException {
        URL resourceUrl = Resources.getResource(this.getClass(), (String)("/templates/" + fileName));
        STGroup stg = new STGroup();
        stg.errMgr = new ErrorManager(this.ERROR_LISTENER);
        stg.loadGroupFile("", resourceUrl.toExternalForm());
        return stg;
    }

    private static class ErrorListener
    implements STErrorListener {
        private ErrorListener() {
        }

        public void compileTimeError(STMessage msg) {
            LOG.error(msg.toString());
        }

        public void runTimeError(STMessage msg) {
            LOG.error(msg.toString());
        }

        public void IOError(STMessage msg) {
            LOG.error(msg.toString());
        }

        public void internalError(STMessage msg) {
            LOG.error(msg.toString());
        }
    }
}

