/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.visitors;

import com.facebook.swift.generator.SwiftDocumentContext;
import com.facebook.swift.generator.SwiftGeneratorConfig;
import com.facebook.swift.generator.template.EnumContext;
import com.facebook.swift.generator.util.TemplateLoader;
import com.facebook.swift.generator.visitors.AbstractTemplateVisitor;
import com.facebook.swift.parser.model.IntegerEnum;
import com.facebook.swift.parser.model.IntegerEnumField;
import com.facebook.swift.parser.visitor.Visitable;
import java.io.File;
import java.io.IOException;

public class IntegerEnumVisitor
extends AbstractTemplateVisitor {
    public IntegerEnumVisitor(TemplateLoader templateLoader, SwiftDocumentContext context, SwiftGeneratorConfig config, File outputFolder) {
        super(templateLoader, context, config, outputFolder);
    }

    public boolean accept(Visitable visitable) {
        return visitable.getClass() == IntegerEnum.class;
    }

    public void visit(Visitable visitable) throws IOException {
        IntegerEnum integerEnum = (IntegerEnum)IntegerEnum.class.cast(visitable);
        EnumContext enumContext = this.contextGenerator.enumFromThrift(integerEnum);
        for (IntegerEnumField field : integerEnum.getFields()) {
            enumContext.addField(this.contextGenerator.fieldFromThrift(field));
        }
        this.render(enumContext, "intEnum");
    }
}

