/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.visitors;

import com.facebook.swift.generator.SwiftDocumentContext;
import com.facebook.swift.generator.SwiftGeneratorConfig;
import com.facebook.swift.generator.template.EnumContext;
import com.facebook.swift.generator.util.TemplateLoader;
import com.facebook.swift.generator.visitors.AbstractTemplateVisitor;
import com.facebook.swift.parser.model.StringEnum;
import com.facebook.swift.parser.visitor.Visitable;
import java.io.File;
import java.io.IOException;

public class StringEnumVisitor
extends AbstractTemplateVisitor {
    public StringEnumVisitor(TemplateLoader templateLoader, SwiftDocumentContext context, SwiftGeneratorConfig config, File outputFolder) {
        super(templateLoader, context, config, outputFolder);
    }

    public boolean accept(Visitable visitable) {
        return visitable.getClass() == StringEnum.class;
    }

    public void visit(Visitable visitable) throws IOException {
        StringEnum stringEnum = (StringEnum)StringEnum.class.cast(visitable);
        EnumContext enumContext = this.contextGenerator.enumFromThrift(stringEnum);
        for (String value : stringEnum.getValues()) {
            enumContext.addField(this.contextGenerator.fieldFromThrift(value));
        }
        this.render(enumContext, "stringEnum");
    }
}

