/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.generator.visitors;

import com.facebook.swift.generator.SwiftDocumentContext;
import com.facebook.swift.generator.SwiftJavaType;
import com.facebook.swift.generator.TypeToJavaConverter;
import com.facebook.swift.generator.template.TemplateContextGenerator;
import com.facebook.swift.parser.model.Typedef;
import com.facebook.swift.parser.visitor.DocumentVisitor;
import com.facebook.swift.parser.visitor.Nameable;
import com.facebook.swift.parser.visitor.Visitable;
import com.google.common.base.Preconditions;
import io.airlift.log.Logger;

public class TypeVisitor
implements DocumentVisitor {
    private static final Logger LOG = Logger.get(TypeVisitor.class);
    private final String javaNamespace;
    private final SwiftDocumentContext documentContext;

    public TypeVisitor(String javaNamespace, SwiftDocumentContext documentContext) {
        this.javaNamespace = javaNamespace;
        this.documentContext = documentContext;
    }

    public boolean accept(Visitable visitable) {
        return visitable instanceof Nameable;
    }

    public void visit(Visitable visitable) {
        Nameable type = (Nameable)Nameable.class.cast(visitable);
        SwiftJavaType swiftJavaType = new SwiftJavaType(this.documentContext.getNamespace(), TemplateContextGenerator.mangleJavaTypeName(type.getName()), type.getName(), this.javaNamespace);
        if (visitable instanceof Typedef) {
            Typedef typedef = (Typedef)Typedef.class.cast(visitable);
            LOG.debug("Checking typedef '%s' as '%s'.", new Object[]{typedef.getType(), typedef.getName()});
            TypeToJavaConverter typeConverter = this.documentContext.getTypeConverter();
            Preconditions.checkNotNull((Object)typeConverter.convertType(typedef.getType()), (String)"typedef %s uses unknown type %s!", (Object[])new Object[]{typedef.getName(), typedef.getType().toString()});
            this.documentContext.getTypedefRegistry().add(swiftJavaType, typedef.getType());
        }
        LOG.debug("Registering type '%s'", new Object[]{swiftJavaType});
        this.documentContext.getTypeRegistry().add(swiftJavaType);
    }

    public void finish() {
    }
}

