/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser.model;

import com.facebook.swift.parser.model.Definition;
import com.facebook.swift.parser.model.Header;
import com.facebook.swift.parser.visitor.DocumentVisitor;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Document {
    private final Header header;
    private final List<Definition> definitions;

    public Document(Header header, List<Definition> definitions) {
        this.header = (Header)Preconditions.checkNotNull((Object)header, (Object)"header");
        this.definitions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(definitions, (Object)"definitions")));
    }

    public Header getHeader() {
        return this.header;
    }

    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    public void visit(DocumentVisitor visitor) throws IOException {
        Preconditions.checkNotNull((Object)visitor, (Object)"the visitor must not be null!");
        for (Definition definition : this.definitions) {
            if (!visitor.accept(definition)) continue;
            definition.visit(visitor);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("header", (Object)this.header).add("definitions", this.definitions).toString();
    }

    public static Document emptyDocument() {
        List<String> includes = Collections.emptyList();
        List<String> cppIncludes = Collections.emptyList();
        String defaultNamespace = null;
        Map<String, String> namespaces = Collections.emptyMap();
        Header header = new Header(includes, cppIncludes, defaultNamespace, namespaces);
        List<Definition> definitions = Collections.emptyList();
        return new Document(header, definitions);
    }
}

