/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Header {
    private final List<String> includes;
    private final Map<String, String> namespaces;
    private final String defaultNamespace;
    private final List<String> cppIncludes;

    public Header(List<String> includes, List<String> cppIncludes, String defaultNamespace, Map<String, String> namespaces) {
        this.includes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(includes, (Object)"includes")));
        this.cppIncludes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(cppIncludes, (Object)"cppIncludes")));
        this.defaultNamespace = defaultNamespace;
        this.namespaces = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(namespaces, (Object)"namespaces")));
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public String getNamespace(String nameSpaceName) {
        String namespace = this.namespaces.get(nameSpaceName);
        if (namespace == null) {
            namespace = this.defaultNamespace;
        }
        return namespace;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public List<String> getCppIncludes() {
        return this.cppIncludes;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("includes", this.includes).add("cppIncludes", this.cppIncludes).add("defaultNamespace", (Object)this.defaultNamespace).add("namespaces", this.namespaces).toString();
    }
}

