/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser.model;

import com.facebook.swift.parser.model.Definition;
import com.facebook.swift.parser.model.ThriftMethod;
import com.facebook.swift.parser.model.TypeAnnotation;
import com.facebook.swift.parser.visitor.DocumentVisitor;
import com.facebook.swift.parser.visitor.Visitable;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class Service
extends Definition {
    private final String name;
    private final Optional<String> parent;
    private final List<ThriftMethod> methods;

    public Service(String name, String parent, List<ThriftMethod> methods, List<TypeAnnotation> annotations) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.parent = Optional.fromNullable((Object)parent);
        this.methods = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(methods, (Object)"methods")));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Optional<String> getParent() {
        return this.parent;
    }

    public List<ThriftMethod> getMethods() {
        return this.methods;
    }

    @Override
    public void visit(DocumentVisitor visitor) throws IOException {
        super.visit(visitor);
        Visitable.Utils.visitAll(visitor, this.getMethods());
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("parent", this.parent).add("methods", this.methods).toString();
    }
}

