/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser;

import com.facebook.swift.parser.TestingUtils;
import com.facebook.swift.parser.ThriftIdlParser;
import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Iterator;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class TestParser {
    @DataProvider
    public Iterator<Object[]> thriftProvider() throws Exception {
        return TestingUtils.listDataProvider(TestingUtils.listMatchingFiles(TestingUtils.getResourcePath(""), "**/*.thrift"));
    }

    @Test(dataProvider="thriftProvider")
    public void testParse(Path path) throws Exception {
        ThriftIdlParser.parseThriftIdl((CharSource)TestParser.pathReader(path));
    }

    @Parameters(value={"sampleDirectory"})
    @Test(groups={"sample"})
    public void testParseSample(String sampleDirectory) throws Exception {
        Path directory = FileSystems.getDefault().getPath(sampleDirectory, new String[0]);
        for (Path path : TestingUtils.listMatchingFiles(directory, "**/*.thrift")) {
            if (path.endsWith("BrokenConstants.thrift")) {
                System.out.println("skipping file: " + path);
                continue;
            }
            System.out.println("parsing file: " + path);
            ThriftIdlParser.parseThriftIdl((CharSource)TestParser.pathReader(path));
        }
    }

    private static CharSource pathReader(Path path) {
        return Files.asByteSource((File)path.toFile()).asCharSource(Charsets.UTF_8);
    }
}

