/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.testng.ITestContext;

public class TestingUtils {
    public static Path getResourcePath(String resourceName) {
        try {
            return Paths.get(Resources.getResource((String)resourceName).toURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static List<Path> listMatchingFiles(Path start, String glob) throws IOException {
        final ImmutableList.Builder list = ImmutableList.builder();
        final PathMatcher matcher = start.getFileSystem().getPathMatcher("glob:" + glob);
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (matcher.matches(file)) {
                    list.add((Object)file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return list.build();
    }

    public static String getTestParameter(ITestContext context, String parameterName) {
        String value = context.getCurrentXmlTest().getParameter(parameterName);
        return (String)Preconditions.checkNotNull((Object)value, (String)"test parameter not set: %s", (Object)parameterName);
    }

    public static Iterator<Object[]> listDataProvider(Object ... list) {
        return TestingUtils.listDataProvider(Arrays.asList(list));
    }

    public static Iterator<Object[]> listDataProvider(List<?> list) {
        return Lists.transform(list, (Function)new Function<Object, Object[]>(){

            public Object[] apply(@Nullable Object input) {
                return new Object[]{input};
            }
        }).iterator();
    }
}

