/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.antlr.runtime.tree.Tree;

public class TreePrinter {
    public static String treeToString(Tree tree) {
        return TreePrinter.treeToString(tree, 1);
    }

    private static String treeToString(Tree tree, int depth) {
        if (tree.getChildCount() == 0) {
            return tree.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(tree.toString());
        for (Tree t : TreePrinter.children(tree)) {
            if (TreePrinter.leafCount(tree) > 2) {
                sb.append("\n");
                sb.append(Strings.repeat((String)"   ", (int)depth));
            } else {
                sb.append(" ");
            }
            sb.append(TreePrinter.treeToString(t, depth + 1));
        }
        sb.append(")");
        return sb.toString();
    }

    private static int leafCount(Tree tree) {
        if (tree.getChildCount() == 0) {
            return 1;
        }
        int n = 0;
        for (Tree t : TreePrinter.children(tree)) {
            n += TreePrinter.leafCount(t);
        }
        return n;
    }

    private static List<Tree> children(Tree tree) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            list.add((Object)tree.getChild(i));
        }
        return list.build();
    }
}

