/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser.model;

import com.facebook.swift.parser.model.Definition;
import com.facebook.swift.parser.model.ThriftField;
import com.facebook.swift.parser.model.TypeAnnotation;
import com.facebook.swift.parser.visitor.DocumentVisitor;
import com.facebook.swift.parser.visitor.Visitable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public abstract class AbstractStruct
extends Definition {
    private final String name;
    private final List<ThriftField> fields;
    private final List<TypeAnnotation> annotations;

    public AbstractStruct(String name, List<ThriftField> fields, List<TypeAnnotation> annotations) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.fields = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(fields, (Object)"fields")));
        this.annotations = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(annotations, (Object)"annotations")));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<ThriftField> getFields() {
        return this.fields;
    }

    public List<TypeAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void visit(DocumentVisitor visitor) throws IOException {
        super.visit(visitor);
        Visitable.Utils.visitAll(visitor, this.getFields());
        Visitable.Utils.visitAll(visitor, this.getAnnotations());
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("fields", this.fields).add("annotations", this.annotations).toString();
    }
}

