/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class IntegerEnumField {
    private final String name;
    private final Optional<Long> explicitValue;
    private final long effectiveValue;

    public IntegerEnumField(String name, Long explicitValue, Long defaultValue) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.explicitValue = Optional.fromNullable((Object)explicitValue);
        this.effectiveValue = this.explicitValue.isPresent() ? ((Long)this.explicitValue.get()).longValue() : defaultValue.longValue();
    }

    public String getName() {
        return this.name;
    }

    public Optional<Long> getExplicitValue() {
        return this.explicitValue;
    }

    public long getValue() {
        return this.effectiveValue;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.effectiveValue).add("explicitValue", this.explicitValue).toString();
    }
}

