/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.parser.model;

import com.facebook.swift.parser.model.ThriftField;
import com.facebook.swift.parser.model.ThriftType;
import com.facebook.swift.parser.model.TypeAnnotation;
import com.facebook.swift.parser.visitor.DocumentVisitor;
import com.facebook.swift.parser.visitor.Visitable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class ThriftMethod
implements Visitable {
    private final String name;
    private final ThriftType returnType;
    private final List<ThriftField> arguments;
    private final boolean oneway;
    private final List<ThriftField> throwsFields;
    private final List<TypeAnnotation> annotations;

    public ThriftMethod(String name, ThriftType returnType, List<ThriftField> arguments, boolean oneway, List<ThriftField> throwsFields, List<TypeAnnotation> annotations) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.returnType = (ThriftType)Preconditions.checkNotNull((Object)returnType, (Object)"returnType");
        this.arguments = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(arguments, (Object)"arguments")));
        this.oneway = oneway;
        this.throwsFields = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(throwsFields, (Object)ImmutableList.of())));
        this.annotations = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(annotations, (Object)"annotations")));
    }

    public String getName() {
        return this.name;
    }

    public ThriftType getReturnType() {
        return this.returnType;
    }

    public List<ThriftField> getArguments() {
        return this.arguments;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public List<ThriftField> getThrowsFields() {
        return this.throwsFields;
    }

    public List<TypeAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void visit(DocumentVisitor visitor) throws IOException {
        Visitable.Utils.visit(visitor, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("returnType", (Object)this.returnType).add("arguments", this.arguments).add("oneway", this.oneway).add("throwsFields", this.throwsFields).add("annotations", this.annotations).toString();
    }
}

