/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.core.NiftyRequestContext;
import com.facebook.nifty.core.RequestContext;
import com.facebook.nifty.core.TNiftyTransport;
import com.facebook.nifty.processor.NiftyProcessor;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ContextChain;
import com.facebook.swift.service.ThriftEventHandler;
import com.facebook.swift.service.ThriftMethodProcessor;
import com.facebook.swift.service.metadata.ThriftMethodMetadata;
import com.facebook.swift.service.metadata.ThriftServiceMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;

@ThreadSafe
public class ThriftServiceProcessor
implements NiftyProcessor {
    private static final Logger LOG = Logger.get(ThriftServiceProcessor.class);
    private final Map<String, ThriftMethodProcessor> methods;
    private final List<ThriftEventHandler> eventHandlers;

    public ThriftServiceProcessor(ThriftCodecManager codecManager, List<? extends ThriftEventHandler> eventHandlers, Object ... services) {
        this(codecManager, eventHandlers, (List<?>)ImmutableList.copyOf((Object[])services));
    }

    public ThriftServiceProcessor(ThriftCodecManager codecManager, List<? extends ThriftEventHandler> eventHandlers, List<?> services) {
        Preconditions.checkNotNull((Object)codecManager, (Object)"codecManager is null");
        Preconditions.checkNotNull(services, (Object)"service is null");
        Preconditions.checkArgument((!services.isEmpty() ? 1 : 0) != 0, (Object)"services is empty");
        HashMap processorMap = Maps.newHashMap();
        for (Object service : services) {
            ThriftServiceMetadata serviceMetadata = new ThriftServiceMetadata(service.getClass(), codecManager.getCatalog());
            for (ThriftMethodMetadata methodMetadata : serviceMetadata.getMethods().values()) {
                String methodName = methodMetadata.getName();
                ThriftMethodProcessor methodProcessor = new ThriftMethodProcessor(service, serviceMetadata.getName(), methodMetadata, codecManager);
                if (processorMap.containsKey(methodName)) {
                    throw new IllegalArgumentException("Multiple @ThriftMethod-annotated methods named '" + methodName + "' found in the given services");
                }
                processorMap.put(methodName, methodProcessor);
            }
        }
        this.methods = ImmutableMap.copyOf((Map)processorMap);
        this.eventHandlers = ImmutableList.copyOf(eventHandlers);
    }

    public Map<String, ThriftMethodProcessor> getMethods() {
        return this.methods;
    }

    public ListenableFuture<Boolean> process(TProtocol in, TProtocol out, RequestContext requestContext) throws TException {
        try {
            final SettableFuture resultFuture = SettableFuture.create();
            TMessage message = in.readMessageBegin();
            String methodName = message.name;
            int sequenceId = message.seqid;
            TNiftyTransport requestTransport = requestContext instanceof NiftyRequestContext ? ((NiftyRequestContext)requestContext).getNiftyTransport() : null;
            ThriftMethodProcessor method = this.methods.get(methodName);
            if (method == null) {
                TProtocolUtil.skip((TProtocol)in, (byte)12);
                ThriftServiceProcessor.writeApplicationException(out, requestTransport, methodName, sequenceId, 1, "Invalid method name: '" + methodName + "'", null);
                return Futures.immediateFuture((Object)true);
            }
            switch (message.type) {
                case 1: 
                case 4: {
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)in, (byte)12);
                    ThriftServiceProcessor.writeApplicationException(out, requestTransport, methodName, sequenceId, 2, "Received invalid message type " + message.type + " from client", null);
                    return Futures.immediateFuture((Object)true);
                }
            }
            final ContextChain context = new ContextChain(this.eventHandlers, method.getQualifiedName(), requestContext);
            ListenableFuture<Boolean> processResult = method.process(in, out, sequenceId, context);
            Futures.addCallback(processResult, (FutureCallback)new FutureCallback<Boolean>(){

                public void onSuccess(Boolean result) {
                    context.done();
                    resultFuture.set((Object)result);
                }

                public void onFailure(Throwable t) {
                    context.done();
                    resultFuture.setException(t);
                }
            });
            return resultFuture;
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public static TApplicationException writeApplicationException(TProtocol outputProtocol, TNiftyTransport requestTransport, String methodName, int sequenceId, int errorCode, String errorMessage, Throwable cause) throws TException {
        TApplicationException applicationException = new TApplicationException(errorCode, errorMessage);
        if (cause != null) {
            applicationException.initCause(cause);
        }
        LOG.error((Throwable)applicationException, errorMessage);
        outputProtocol.writeMessageBegin(new TMessage(methodName, 3, sequenceId));
        applicationException.write(outputProtocol);
        outputProtocol.writeMessageEnd();
        if (requestTransport != null) {
            requestTransport.setTApplicationException(applicationException);
        }
        outputProtocol.getTransport().flush();
        return applicationException;
    }
}

