/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.core.NiftyRequestContext;
import com.facebook.nifty.core.RequestContext;
import com.facebook.swift.service.ThriftEventHandler;
import com.facebook.swift.service.ThriftMethodStats;
import io.airlift.units.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class ThriftServiceStatsHandler
extends ThriftEventHandler {
    private final ConcurrentHashMap<String, ThriftMethodStats> stats = new ConcurrentHashMap();

    private static Duration nanosBetween(long start, long end) {
        return new Duration((double)(end - start), TimeUnit.NANOSECONDS);
    }

    public ConcurrentMap<String, ThriftMethodStats> getStats() {
        return this.stats;
    }

    @Override
    public Object getContext(String methodName, RequestContext requestContext) {
        this.stats.putIfAbsent(methodName, new ThriftMethodStats());
        return new PerCallMethodStats(requestContext);
    }

    @Override
    public void preRead(Object context, String methodName) {
        ((PerCallMethodStats)context).preReadTime = System.nanoTime();
    }

    @Override
    public void postRead(Object context, String methodName, Object[] args) {
        long now = System.nanoTime();
        PerCallMethodStats ctx = (PerCallMethodStats)context;
        ctx.postReadTime = now;
        this.stats.get(methodName).addReadTime(ThriftServiceStatsHandler.nanosBetween(ctx.preReadTime, now));
        this.stats.get(methodName).addReadByteCount(this.getBytesRead(ctx));
    }

    @Override
    public void preWrite(Object context, String methodName, Object result) {
        long now = System.nanoTime();
        PerCallMethodStats ctx = (PerCallMethodStats)context;
        ctx.preWriteTime = now;
        this.stats.get(methodName).addInvokeTime(ThriftServiceStatsHandler.nanosBetween(ctx.postReadTime, now));
    }

    @Override
    public void preWriteException(Object context, String methodName, Throwable t) {
        this.preWrite(context, methodName, null);
        ((PerCallMethodStats)context).success = false;
    }

    @Override
    public void postWrite(Object context, String methodName, Object result) {
        PerCallMethodStats ctx = (PerCallMethodStats)context;
        this.stats.get(methodName).addWriteTime(Duration.nanosSince((long)ctx.preWriteTime));
        this.stats.get(methodName).addWriteByteCount(this.getBytesWritten(ctx));
    }

    @Override
    public void postWriteException(Object context, String methodName, Throwable t) {
        this.postWrite(context, methodName, null);
    }

    @Override
    public void done(Object context, String methodName) {
        PerCallMethodStats ctx = (PerCallMethodStats)context;
        Duration duration = Duration.nanosSince((long)ctx.startTime);
        if (ctx.success) {
            this.stats.get(methodName).addSuccessTime(duration);
        } else {
            this.stats.get(methodName).addErrorTime(duration);
        }
    }

    private int getBytesRead(PerCallMethodStats ctx) {
        if (!(ctx.requestContext instanceof NiftyRequestContext)) {
            return 0;
        }
        NiftyRequestContext requestContext = (NiftyRequestContext)ctx.requestContext;
        return requestContext.getNiftyTransport().getReadByteCount();
    }

    private int getBytesWritten(PerCallMethodStats ctx) {
        if (!(ctx.requestContext instanceof NiftyRequestContext)) {
            return 0;
        }
        NiftyRequestContext requestContext = (NiftyRequestContext)ctx.requestContext;
        return requestContext.getNiftyTransport().getWrittenByteCount();
    }

    private static class PerCallMethodStats {
        public final RequestContext requestContext;
        public boolean success = true;
        public long startTime = System.nanoTime();
        public long preReadTime;
        public long postReadTime;
        public long preWriteTime;

        public PerCallMethodStats(RequestContext requestContext) {
            this.requestContext = requestContext;
        }
    }
}

