/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.guice;

import com.facebook.swift.service.ThriftClientEventHandler;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.ThriftClientStatsHandler;
import com.facebook.swift.service.ThriftMethodHandler;
import com.facebook.swift.service.ThriftMethodStats;
import com.facebook.swift.service.guice.ClientEventHandlersBinder;
import com.facebook.swift.service.guice.ThriftClientBinder;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Singleton;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MapObjectNameFunction;

public class ThriftClientStatsModule
implements Module {
    public void configure(Binder binder) {
        Multibinder.newSetBinder((Binder)binder, ThriftClientBinder.ThriftClientProvider.class).permitDuplicates();
        binder.bind(ThriftClientStatsHandler.class).in(Scopes.SINGLETON);
        ClientEventHandlersBinder.clientEventHandlersBinder(binder).addHandler(ThriftClientStatsHandler.class);
        ExportBinder.newExporter((Binder)binder).exportMap(ObjectName.class, ThriftMethodStats.class).withGeneratedName((MapObjectNameFunction)new MapObjectNameFunction<ObjectName, ThriftMethodStats>(){

            public ObjectName name(ObjectName key, ThriftMethodStats value) {
                return key;
            }
        });
    }

    @Provides
    @Singleton
    public Map<ObjectName, ThriftMethodStats> getClientStats(Set<ThriftClientBinder.ThriftClientProvider> clientProviders, Set<ThriftClientEventHandler> eventHandlers) {
        ConcurrentMap<String, ThriftMethodStats> stats = null;
        for (ThriftClientEventHandler h : eventHandlers) {
            if (!(h instanceof ThriftClientStatsHandler)) continue;
            stats = ((ThriftClientStatsHandler)h).getStats();
            break;
        }
        if (stats == null) {
            return ImmutableMap.of();
        }
        try {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ThriftClientBinder.ThriftClientProvider clientProvider : clientProviders) {
                ThriftClientManager.ThriftClientMetadata clientMetadata = clientProvider.getClientMetadata();
                for (ThriftMethodHandler methodHandler : clientMetadata.getMethodHandlers().values()) {
                    String name = String.format("com.facebook.swift.client:type=%s,clientName=%s,name=%s", clientMetadata.getClientType(), clientMetadata.getClientName(), methodHandler.getName());
                    stats.putIfAbsent(methodHandler.getQualifiedName(), new ThriftMethodStats());
                    builder.put((Object)ObjectName.getInstance(name), stats.get(methodHandler.getQualifiedName()));
                }
            }
            return builder.build();
        }
        catch (MalformedObjectNameException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

