/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.guice;

import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ThriftEventHandler;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

public class ThriftServiceExporter {
    private final Binder binder;

    public static ThriftServiceExporter thriftServerBinder(Binder binder) {
        return new ThriftServiceExporter(binder);
    }

    private ThriftServiceExporter(Binder binder) {
        this.binder = binder;
    }

    public <T> void exportThriftService(Class<T> thriftServer) {
        Preconditions.checkNotNull(thriftServer, (Object)"thriftServer is null");
        Multibinder.newSetBinder((Binder)this.binder, ThriftServiceExport.class).addBinding().toInstance((Object)new ThriftServiceExport(Key.get(thriftServer)));
    }

    public <T> void exportThriftService(Class<T> thriftServer, Class<? extends Annotation> annotationType) {
        Preconditions.checkNotNull(thriftServer, (Object)"thriftServer is null");
        Multibinder.newSetBinder((Binder)this.binder, ThriftServiceExport.class).addBinding().toInstance((Object)new ThriftServiceExport(Key.get(thriftServer, annotationType)));
    }

    public <T> void exportThriftService(Key<T> key) {
        Preconditions.checkNotNull(key, (Object)"key is null");
        Multibinder.newSetBinder((Binder)this.binder, ThriftServiceExport.class).addBinding().toInstance((Object)new ThriftServiceExport(key));
    }

    public void addEventHandler(ThriftEventHandler handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"handler is null");
        Multibinder.newSetBinder((Binder)this.binder, ThriftEventHandler.class).addBinding().toInstance((Object)handler);
    }

    public void addEventHandler(Key<? extends ThriftEventHandler> key) {
        Preconditions.checkNotNull(key, (Object)"key is null");
        Multibinder.newSetBinder((Binder)this.binder, ThriftEventHandler.class).addBinding().to(key);
    }

    public void addEventHandler(Class<? extends ThriftEventHandler> cls) {
        Preconditions.checkNotNull(cls, (Object)"cls is null");
        Multibinder.newSetBinder((Binder)this.binder, ThriftEventHandler.class).addBinding().to(cls);
    }

    public static class ThriftServiceExport {
        private final Key<?> key;

        public ThriftServiceExport(Key<?> key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThriftServiceExport that = (ThriftServiceExport)o;
            return this.key.equals(that.key);
        }

        public Key<?> getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ThriftServerBinding");
            sb.append("{key=").append(this.key);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class ThriftServiceProcessorProvider
    implements Provider<ThriftServiceProcessor> {
        private final Injector injector;
        private final ThriftCodecManager codecManager;
        private final Set<ThriftEventHandler> eventHandlers;
        private final Set<ThriftServiceExport> serviceExports;

        @Inject
        public ThriftServiceProcessorProvider(Injector injector, ThriftCodecManager codecManager, Set<ThriftEventHandler> eventHandlers, Set<ThriftServiceExport> serviceExports) {
            this.injector = injector;
            this.codecManager = codecManager;
            this.eventHandlers = eventHandlers;
            this.serviceExports = serviceExports;
        }

        public ThriftServiceProcessor get() {
            ImmutableList.Builder servers = ImmutableList.builder();
            for (ThriftServiceExport serviceExport : this.serviceExports) {
                Object server = this.injector.getInstance(serviceExport.getKey());
                servers.add(server);
            }
            return new ThriftServiceProcessor(this.codecManager, (List<? extends ThriftEventHandler>)ImmutableList.copyOf(this.eventHandlers), (List<?>)servers.build());
        }
    }
}

