/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftIdlAnnotation;
import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.metadata.DefaultThriftTypeReference;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.ThriftTypeReference;
import com.facebook.swift.service.ThriftException;
import com.facebook.swift.service.ThriftMethod;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.TException;

@Immutable
public class ThriftMethodMetadata {
    private final String name;
    private final String qualifiedName;
    private final ThriftType returnType;
    private final List<ThriftFieldMetadata> parameters;
    private final Method method;
    private final ImmutableMap<Short, ThriftType> exceptions;
    private final ImmutableList<String> documentation;
    private final boolean oneway;

    public ThriftMethodMetadata(String serviceName, Method method, ThriftCatalog catalog) {
        Preconditions.checkNotNull((Object)method, (Object)"method is null");
        Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        this.method = method;
        ThriftMethod thriftMethod = method.getAnnotation(ThriftMethod.class);
        Preconditions.checkArgument((thriftMethod != null ? 1 : 0) != 0, (Object)"Method is not annotated with @ThriftMethod");
        Preconditions.checkArgument((!Modifier.isStatic(method.getModifiers()) ? 1 : 0) != 0, (String)"Method %s is static", (Object[])new Object[]{method.toGenericString()});
        this.name = thriftMethod.value().length() == 0 ? method.getName() : thriftMethod.value();
        this.qualifiedName = serviceName + "." + this.name;
        this.documentation = ThriftCatalog.getThriftDocumentation((Method)method);
        this.returnType = catalog.getThriftType(method.getGenericReturnType());
        ImmutableList.Builder builder = ImmutableList.builder();
        Type[] parameterTypes = method.getGenericParameterTypes();
        String[] parameterNames = ReflectionHelper.extractParameterNames((AccessibleObject)method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int index = 0; index < parameterTypes.length; ++index) {
            ThriftField thriftField = null;
            for (Annotation annotation : parameterAnnotations[index]) {
                if (!(annotation instanceof ThriftField)) continue;
                thriftField = (ThriftField)annotation;
                break;
            }
            short parameterId = Short.MIN_VALUE;
            boolean isLegacyId = false;
            String parameterName = null;
            ImmutableMap parameterIdlAnnotations = null;
            ThriftField.Requiredness parameterRequiredness = ThriftField.Requiredness.UNSPECIFIED;
            if (thriftField != null) {
                parameterId = thriftField.value();
                isLegacyId = thriftField.isLegacyId();
                parameterRequiredness = thriftField.requiredness();
                ImmutableMap.Builder idlAnnotationsBuilder = ImmutableMap.builder();
                if (thriftField != null) {
                    for (ThriftIdlAnnotation idlAnnotation : thriftField.idlAnnotations()) {
                        idlAnnotationsBuilder.put((Object)idlAnnotation.key(), (Object)idlAnnotation.value());
                    }
                }
                parameterIdlAnnotations = idlAnnotationsBuilder.build();
                if (!thriftField.name().isEmpty()) {
                    parameterName = thriftField.name();
                }
            }
            if (parameterId == Short.MIN_VALUE) {
                parameterId = (short)(index + 1);
            }
            if (parameterName == null) {
                parameterName = parameterNames[index];
            }
            Type parameterType = parameterTypes[index];
            ThriftType thriftType = catalog.getThriftType(parameterType);
            ThriftParameterInjection parameterInjection = new ThriftParameterInjection(parameterId, parameterName, index, parameterType);
            if (parameterRequiredness == ThriftField.Requiredness.UNSPECIFIED) {
                parameterRequiredness = ThriftField.Requiredness.NONE;
            }
            ThriftFieldMetadata fieldMetadata = new ThriftFieldMetadata(parameterId, isLegacyId, false, parameterRequiredness, (Map)parameterIdlAnnotations, (ThriftTypeReference)new DefaultThriftTypeReference(thriftType), parameterName, FieldKind.THRIFT_FIELD, (List)ImmutableList.of((Object)parameterInjection), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent());
            builder.add((Object)fieldMetadata);
        }
        this.parameters = builder.build();
        this.exceptions = this.buildExceptionMap(catalog, thriftMethod);
        this.oneway = thriftMethod.oneway();
    }

    public String getName() {
        return this.name;
    }

    public ThriftType getReturnType() {
        return this.returnType;
    }

    public List<ThriftFieldMetadata> getParameters() {
        return this.parameters;
    }

    public Map<Short, ThriftType> getExceptions() {
        return this.exceptions;
    }

    public ThriftType getException(short id) {
        return (ThriftType)this.exceptions.get((Object)id);
    }

    public ImmutableList<String> getDocumentation() {
        return this.documentation;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean getOneway() {
        return this.oneway;
    }

    private ImmutableMap<Short, ThriftType> buildExceptionMap(ThriftCatalog catalog, ThriftMethod thriftMethod) {
        ImmutableMap.Builder exceptions = ImmutableMap.builder();
        HashSet<Class> exceptionTypes = new HashSet<Class>();
        int customExceptionCount = 0;
        if (thriftMethod.exception().length > 0) {
            for (ThriftException thriftException : thriftMethod.exception()) {
                exceptions.put((Object)thriftException.id(), (Object)catalog.getThriftType((Type)thriftException.type()));
                Preconditions.checkState((boolean)exceptionTypes.add(thriftException.type()), (String)"ThriftMethod.exception contains more than one value for %s", (Object[])new Object[]{thriftException.type()});
            }
        }
        for (Class<TException> clazz : this.method.getExceptionTypes()) {
            if (clazz.isAssignableFrom(TException.class) || !clazz.isAnnotationPresent(ThriftStruct.class)) continue;
            ++customExceptionCount;
            if (exceptionTypes.contains(clazz)) continue;
            Preconditions.checkState((customExceptionCount <= 1 ? 1 : 0) != 0, (Object)"ThriftMethod.exception annotation value must be specified when more than one custom exception is thrown.");
            exceptions.put((Object)1, (Object)catalog.getThriftType(clazz));
        }
        return exceptions.build();
    }

    public boolean isAsync() {
        Type returnType = this.method.getGenericReturnType();
        Class rawType = TypeToken.of((Type)returnType).getRawType();
        return ListenableFuture.class.isAssignableFrom(rawType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftMethodMetadata that = (ThriftMethodMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.method, that.method) && Objects.equals(this.exceptions, that.exceptions) && Objects.equals(this.oneway, that.oneway);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnType, this.parameters, this.method, this.exceptions, this.oneway);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }
}

