/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ResultCode;
import com.facebook.swift.service.SwiftScribe;
import com.facebook.swift.service.ThriftMethod;
import com.facebook.swift.service.ThriftScribeService;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.ThriftService;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.facebook.swift.service.scribe.LogEntry;
import com.facebook.swift.service.scribe.scribe;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftService {
    @Test
    public void testSwiftService() throws Exception {
        SwiftScribe scribeService = new SwiftScribe();
        ThriftServiceProcessor processor = new ThriftServiceProcessor(new ThriftCodecManager(new ThriftCodec[0]), new Object[]{scribeService});
        List<LogEntry> messages = this.testProcessor((TProcessor)processor);
        Assert.assertEquals(scribeService.getMessages(), (Collection)Lists.newArrayList((Iterable)Iterables.concat(this.toSwiftLogEntry(messages), this.toSwiftLogEntry(messages))));
    }

    @Test
    public void testThriftService() throws Exception {
        ThriftScribeService scribeService = new ThriftScribeService();
        scribe.Processor<ThriftScribeService> processor = new scribe.Processor<ThriftScribeService>(scribeService);
        List<LogEntry> messages = this.testProcessor(processor);
        Assert.assertEquals(scribeService.getMessages(), (Collection)Lists.newArrayList((Iterable)Iterables.concat(messages, messages)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="duplicate key.*")
    public void testConflictingServices() throws Exception {
        new ThriftServiceProcessor(new ThriftCodecManager(new ThriftCodec[0]), new Object[]{new SwiftScribe(), new ConflictingLogService()});
    }

    private List<LogEntry> testProcessor(TProcessor processor) throws Exception {
        ImmutableList messages = ImmutableList.of((Object)new LogEntry("hello", "world"), (Object)new LogEntry("bye", "world"));
        try (ThriftServer server = new ThriftServer(processor).start();){
            Assert.assertEquals((Object)((Object)this.logThrift(server.getPort(), (List<LogEntry>)messages)), (Object)((Object)com.facebook.swift.service.scribe.ResultCode.OK));
            Assert.assertEquals((Object)((Object)this.logSwift(server.getPort(), this.toSwiftLogEntry((List<LogEntry>)messages))), (Object)((Object)ResultCode.OK));
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.facebook.swift.service.scribe.ResultCode logThrift(int port, List<LogEntry> messages) throws TException {
        socket.open();
        try (TSocket socket = new TSocket("localhost", port);){
            TBinaryProtocol tp = new TBinaryProtocol((TTransport)new TFramedTransport((TTransport)socket));
            com.facebook.swift.service.scribe.ResultCode resultCode = new scribe.Client((TProtocol)tp).Log(messages);
            return resultCode;
        }
    }

    /*
     * Exception decompiling
     */
    private ResultCode logSwift(int port, List<com.facebook.swift.service.LogEntry> entries) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<com.facebook.swift.service.LogEntry> toSwiftLogEntry(List<LogEntry> messages) {
        return Lists.transform(messages, (Function)new Function<LogEntry, com.facebook.swift.service.LogEntry>(){

            public com.facebook.swift.service.LogEntry apply(@Nullable LogEntry input) {
                return new com.facebook.swift.service.LogEntry(input.category, input.message);
            }
        });
    }

    @ThriftService
    public class ConflictingLogService {
        @ThriftMethod
        public void Log(List<String> messages) throws TException {
        }
    }
}

