/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.async;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.async.AsyncTestBase;
import com.facebook.swift.service.async.DelayedMap;
import com.facebook.swift.service.async.DelayedMapSyncHandler;
import com.facebook.swift.service.async.MalformedService;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AsyncClientTest
extends AsyncTestBase {
    protected ThriftServer syncServer;

    @Test
    public void testSyncClient() throws Exception {
        try (DelayedMap.Client client = (DelayedMap.Client)this.createClient(DelayedMap.Client.class, this.syncServer).get();){
            ArrayList keys = Lists.newArrayList((Object[])new String[]{"testKey"});
            List<String> values = client.getMultipleValues(0L, TimeUnit.SECONDS, keys);
            Assert.assertEquals(values, (Collection)Lists.newArrayList((Object[])new String[]{"default"}));
            client.putValueSlowly(0L, TimeUnit.SECONDS, "testKey", "testValue");
        }
    }

    @Test
    public void testAsyncClient() throws Exception {
        try (DelayedMap.AsyncClient client = (DelayedMap.AsyncClient)this.createClient(DelayedMap.AsyncClient.class, this.syncServer).get();){
            ListenableFuture<String> getBeforeFuture = client.getValueSlowly(200L, TimeUnit.MILLISECONDS, "testKey");
            ListenableFuture<Void> putFuture = client.putValueSlowly(400L, TimeUnit.MILLISECONDS, "testKey", "testValue");
            ListenableFuture<String> getAfterFuture = client.getValueSlowly(600L, TimeUnit.MILLISECONDS, "testKey");
            Assert.assertEquals((String)((String)Uninterruptibles.getUninterruptibly(getBeforeFuture)), (String)"default");
            Assert.assertEquals((String)((String)Uninterruptibles.getUninterruptibly(getAfterFuture)), (String)"testValue");
            Uninterruptibles.getUninterruptibly(putFuture);
        }
    }

    @Test(timeOut=2000L)
    void testAsyncConnection() throws Exception {
        ListenableFuture<DelayedMap.AsyncClient> future = this.createClient(DelayedMap.AsyncClient.class, this.syncServer);
        AsyncConnectionCallback futureCallback = new AsyncConnectionCallback();
        Futures.addCallback(future, (FutureCallback)futureCallback);
        futureCallback.waitForAsyncCallsToBeDispatched();
        futureCallback.checkAsyncCallReturnValues();
    }

    @Test
    public void testAsyncOutOfOrder() throws Exception {
        try (DelayedMap.AsyncClient client = (DelayedMap.AsyncClient)this.createClient(DelayedMap.AsyncClient.class, this.syncServer).get();){
            ListenableFuture<String> getFuture = client.getValueSlowly(500L, TimeUnit.MILLISECONDS, "testKey");
            ListenableFuture<Void> putFuture = client.putValueSlowly(250L, TimeUnit.MILLISECONDS, "testKey", "testValue");
            Assert.assertEquals((String)((String)getFuture.get(1L, TimeUnit.SECONDS)), (String)"testValue");
            putFuture.get(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testAsyncEarlyListener() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        try (DelayedMap.AsyncClient client = (DelayedMap.AsyncClient)this.createClient(DelayedMap.AsyncClient.class, this.syncServer).get();){
            ListenableFuture<String> getFuture = client.getValueSlowly(500L, TimeUnit.MILLISECONDS, "testKey");
            Futures.addCallback(getFuture, (FutureCallback)new FutureCallback<String>(){

                public void onSuccess(String result) {
                    latch.countDown();
                }

                public void onFailure(Throwable t) {
                }
            });
            latch.await();
        }
    }

    @Test
    public void testAsyncTimeout() throws Exception {
        try (DelayedMap.AsyncClient client = (DelayedMap.AsyncClient)this.createClient(DelayedMap.AsyncClient.class, this.syncServer).get();){
            ListenableFuture<String> getFuture = client.getValueSlowly(1500L, TimeUnit.MILLISECONDS, "testKey");
            try {
                getFuture.get(2000L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Call did not timeout as expected");
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Waited too long for channel timeout");
            }
            catch (ExecutionException e) {
                this.checkTransportException(e.getCause(), ReadTimeoutException.class);
            }
        }
    }

    @Test
    public void testAsyncLateListener() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        try (DelayedMap.AsyncClient client = (DelayedMap.AsyncClient)this.createClient(DelayedMap.AsyncClient.class, this.syncServer).get();){
            ListenableFuture<String> getFuture = client.getValueSlowly(250L, TimeUnit.MILLISECONDS, "testKey");
            Thread.sleep(500L);
            Futures.addCallback(getFuture, (FutureCallback)new FutureCallback<String>(){

                public void onSuccess(String result) {
                    latch.countDown();
                }

                public void onFailure(Throwable t) {
                }
            });
            latch.await(0L, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void testClientCreateFailure() throws InterruptedException, ExecutionException, TTransportException {
        try {
            this.createClient(MalformedService.class, this.syncServer).get();
            Assert.fail((String)"Should not be able to successfully create a client for MalformedService.class");
        }
        catch (ExecutionException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            Assert.assertTrue((boolean)(rootCause instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)rootCause.getMessage().startsWith("Type can not be coerced to a Thrift type"));
        }
    }

    private ThriftServer createSyncServer() throws InstantiationException, IllegalAccessException, TException {
        DelayedMapSyncHandler handler = new DelayedMapSyncHandler();
        handler.putValueSlowly(0L, TimeUnit.MILLISECONDS, "testKey", "default");
        return this.createServerFromHandler(handler);
    }

    private void checkTransportException(Throwable throwable, Class<? extends Throwable> expectedCause) {
        Assert.assertNotNull((Object)throwable);
        Throwable cause = throwable.getCause();
        if (!(throwable instanceof TTransportException)) {
            Assert.fail((String)("Exception of type " + throwable.getClass() + " when expecting a TTransportException"));
        } else if (!expectedCause.isAssignableFrom(throwable.getCause().getClass())) {
            Assert.fail((String)("TTransportException caused by " + cause.getClass() + " when expecting a TTransportException caused by " + expectedCause));
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() throws IllegalAccessException, InstantiationException, TException {
        this.codecManager = new ThriftCodecManager(new ThriftCodec[0]);
        this.clientManager = new ThriftClientManager(this.codecManager);
        this.syncServer = this.createSyncServer();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.syncServer.close();
        this.clientManager.close();
    }

    class AsyncConnectionCallback
    implements FutureCallback<DelayedMap.AsyncClient> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private ListenableFuture<String> getBeforeFuture = null;
        private ListenableFuture<String> getAfterFuture = null;
        private ListenableFuture<Void> putFuture = null;

        AsyncConnectionCallback() {
        }

        public void onSuccess(DelayedMap.AsyncClient client) {
            try {
                this.getBeforeFuture = client.getValueSlowly(200L, TimeUnit.MILLISECONDS, "testKey");
                this.putFuture = client.putValueSlowly(400L, TimeUnit.MILLISECONDS, "testKey", "testValue");
                this.getAfterFuture = client.getValueSlowly(600L, TimeUnit.MILLISECONDS, "testKey");
            }
            catch (Throwable t) {
                this.onFailure(t);
            }
            this.latch.countDown();
        }

        public void onFailure(Throwable t) {
            this.latch.countDown();
        }

        public void waitForAsyncCallsToBeDispatched() throws InterruptedException {
            this.latch.await();
        }

        public void checkAsyncCallReturnValues() throws ExecutionException, InterruptedException {
            Assert.assertFalse((boolean)this.getBeforeFuture.isDone());
            Assert.assertFalse((boolean)this.getAfterFuture.isDone());
            Assert.assertFalse((boolean)this.putFuture.isDone());
            Assert.assertEquals((String)((String)this.getBeforeFuture.get()), (String)"default");
            Assert.assertEquals((String)((String)this.getAfterFuture.get()), (String)"testValue");
            this.putFuture.get();
        }
    }
}

