/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.async;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.LogEntry;
import com.facebook.swift.service.ResultCode;
import com.facebook.swift.service.Scribe;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.async.AsyncScribe;
import com.facebook.swift.service.async.AsyncTestBase;
import com.facebook.swift.service.async.HttpScribeServer;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CountDownLatch;
import org.apache.thrift.TException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AsyncHttpClientTest
extends AsyncTestBase {
    @Test
    public void testHttpClient() throws Exception {
        try (HttpScribeServer server = new HttpScribeServer();){
            server.start();
            Assert.assertEquals((int)server.getLogEntries().size(), (int)0);
            int serverPort = server.getLocalPort();
            try (Scribe client = (Scribe)this.createHttpClient(Scribe.class, serverPort).get();){
                client.log(Lists.newArrayList((Object[])new LogEntry[]{new LogEntry("testCategory", "testMessage")}));
            }
            Assert.assertEquals((int)server.getLogEntries().size(), (int)1);
        }
    }

    @Test
    public void testHttpAsyncClient() throws Exception {
        try (final HttpScribeServer server = new HttpScribeServer();){
            server.start();
            final CountDownLatch latch = new CountDownLatch(1);
            Assert.assertEquals((int)server.getLogEntries().size(), (int)0);
            int serverPort = server.getLocalPort();
            ListenableFuture<AsyncScribe> clientFuture = this.createHttpClient(AsyncScribe.class, serverPort);
            Futures.addCallback(clientFuture, (FutureCallback)new FutureCallback<AsyncScribe>(){

                public void onSuccess(AsyncScribe client) {
                    try {
                        ListenableFuture<ResultCode> methodFuture = client.log(Lists.newArrayList((Object[])new LogEntry[]{new LogEntry("testCategory", "testMessage")}));
                        Assert.assertEquals((int)server.getLogEntries().size(), (int)0);
                        Futures.addCallback(methodFuture, (FutureCallback)new FutureCallback<ResultCode>(){

                            public void onSuccess(ResultCode result) {
                                latch.countDown();
                            }

                            public void onFailure(Throwable t) {
                                latch.countDown();
                            }
                        });
                    }
                    catch (Throwable th) {
                        this.onFailure(th);
                    }
                }

                public void onFailure(Throwable t) {
                    latch.countDown();
                }
            });
            latch.await();
            Assert.assertEquals((int)server.getLogEntries().size(), (int)1);
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() throws IllegalAccessException, InstantiationException, TException {
        this.codecManager = new ThriftCodecManager(new ThriftCodec[0]);
        this.clientManager = new ThriftClientManager(this.codecManager);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.clientManager.close();
    }
}

