/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.async;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.async.AsyncTestBase;
import com.facebook.swift.service.async.DelayedMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AsyncService
extends AsyncTestBase {
    private ThriftServer asyncServer;

    @Test(timeOut=1000L)
    public void testAsyncService() throws Exception {
        try (DelayedMap.Client client = (DelayedMap.Client)this.createClient(DelayedMap.Client.class, this.asyncServer).get();){
            ArrayList keys = Lists.newArrayList((Object[])new String[]{"testKey"});
            List<String> values = client.getMultipleValues(0L, TimeUnit.SECONDS, keys);
            Assert.assertEquals(values, (Collection)Lists.newArrayList((Object[])new String[]{"default"}));
        }
    }

    @BeforeMethod(alwaysRun=true)
    private void setup() throws IllegalAccessException, InstantiationException, TException {
        this.codecManager = new ThriftCodecManager(new ThriftCodec[0]);
        this.clientManager = new ThriftClientManager(this.codecManager);
        this.asyncServer = this.createAsyncServer();
    }

    @AfterMethod(alwaysRun=true)
    private void tearDown() {
        this.clientManager.close();
        this.asyncServer.close();
    }
}

