/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.async;

import com.facebook.nifty.client.FramedClientChannel;
import com.facebook.nifty.client.FramedClientConnector;
import com.facebook.nifty.client.HttpClientConnector;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ThriftClient;
import com.facebook.swift.service.ThriftClientConfig;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.ThriftServerConfig;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.facebook.swift.service.async.DelayedMapAsyncHandler;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.util.Timer;

public class AsyncTestBase {
    public static final int MAX_FRAME_SIZE = 0x3FFFFFFF;
    protected ThriftCodecManager codecManager;
    protected ThriftClientManager clientManager;
    public static final Duration NO_CLIENT_CREATION_DELAY = Duration.valueOf((String)"0ms");
    public static final Duration DEFAULT_CLIENT_CREATION_DELAY = Duration.valueOf((String)"10ms");

    protected <T> ListenableFuture<T> createClient(Class<T> clientClass, ThriftServer server) throws InterruptedException, ExecutionException, TTransportException {
        return this.createClient(clientClass, server, DEFAULT_CLIENT_CREATION_DELAY);
    }

    protected <T> ListenableFuture<T> createClient(Class<T> clientClass, int port) throws InterruptedException, ExecutionException, TTransportException {
        return this.createClient(clientClass, port, DEFAULT_CLIENT_CREATION_DELAY);
    }

    protected <T> ListenableFuture<T> createClient(Class<T> clientClass, ThriftServer server, Duration connectDelay) throws TTransportException, InterruptedException, ExecutionException {
        return this.createClient(clientClass, server.getPort(), connectDelay);
    }

    protected <T> ListenableFuture<T> createClient(Class<T> clientClass, int serverPort, final Duration connectDelay) throws TTransportException, InterruptedException, ExecutionException {
        HostAndPort address = HostAndPort.fromParts((String)"localhost", (int)serverPort);
        ThriftClientConfig config = new ThriftClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.SECONDS)).setReadTimeout(new Duration(1.0, TimeUnit.SECONDS)).setWriteTimeout(new Duration(1.0, TimeUnit.SECONDS));
        FramedClientConnector connector = new FramedClientConnector(address){

            public FramedClientChannel newThriftClientChannel(Channel nettyChannel, Timer timer) {
                if ((long)connectDelay.convertTo(TimeUnit.NANOSECONDS) > 0L) {
                    Uninterruptibles.sleepUninterruptibly((long)((long)connectDelay.convertTo(TimeUnit.NANOSECONDS)), (TimeUnit)TimeUnit.NANOSECONDS);
                }
                return super.newThriftClientChannel(nettyChannel, timer);
            }
        };
        return new ThriftClient(this.clientManager, clientClass, config, "asyncTestClient").open((NiftyClientConnector)connector);
    }

    protected <T> ListenableFuture<T> createHttpClient(Class<T> clientClass, int serverPort) throws TTransportException, InterruptedException, ExecutionException {
        ThriftClientConfig config = new ThriftClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.SECONDS)).setReadTimeout(new Duration(1.0, TimeUnit.SECONDS)).setWriteTimeout(new Duration(1.0, TimeUnit.SECONDS));
        HttpClientConnector connector = new HttpClientConnector(URI.create("http://localhost:" + serverPort + "/thrift/"));
        return new ThriftClient(this.clientManager, clientClass, config, "asyncTestClient").open((NiftyClientConnector)connector);
    }

    protected ThriftServer createAsyncServer() throws InstantiationException, IllegalAccessException, TException {
        DelayedMapAsyncHandler handler = new DelayedMapAsyncHandler();
        handler.putValueSlowly(0L, TimeUnit.MILLISECONDS, "testKey", "default");
        return this.createServerFromHandler(handler);
    }

    protected ThriftServer createServerFromHandler(Object handler) throws IllegalAccessException, InstantiationException {
        ThriftServiceProcessor processor = new ThriftServiceProcessor(this.codecManager, new Object[]{handler});
        ThriftServerConfig config = new ThriftServerConfig();
        config.setMaxFrameSize(new DataSize(1.073741823E9, DataSize.Unit.BYTE));
        return new ThriftServer((TProcessor)processor, config).start();
    }
}

