/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.async;

import com.facebook.swift.service.async.DelayedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;

public class DelayedMapSyncHandler
implements DelayedMap.Service {
    private Map<String, String> store = new HashMap<String, String>();

    @Override
    public void putValueSlowly(long timeout, TimeUnit unit, String key, String value) throws TException {
        this.checkedSleep(timeout, unit);
        this.store.put(key, value);
    }

    @Override
    public String getValueSlowly(long timeout, TimeUnit unit, String key) throws TException {
        this.checkedSleep(timeout, unit);
        return this.store.get(key);
    }

    @Override
    public List<String> getMultipleValues(long timeout, TimeUnit unit, List<String> keys) throws TException {
        this.checkedSleep(timeout, unit);
        ArrayList<String> result = new ArrayList<String>();
        for (String key : keys) {
            result.add(this.store.get(key));
        }
        return result;
    }

    private void checkedSleep(long timeout, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(timeout));
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
    }
}

