/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.async;

import com.facebook.swift.service.scribe.LogEntry;
import com.facebook.swift.service.scribe.ResultCode;
import com.facebook.swift.service.scribe.scribe;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HttpScribeServer
implements AutoCloseable {
    Server jettyServer;

    public void start() throws Exception {
        this.jettyServer = this.createServer();
    }

    @Override
    public void close() throws Exception {
        this.shutdownServer(this.jettyServer);
    }

    public int getLocalPort() {
        return this.jettyServer.getConnectors()[0].getLocalPort();
    }

    public List<LogEntry> getLogEntries() throws ServletException {
        return this.getServerServlet(this.jettyServer).getLogEntries();
    }

    private Server createServer() throws Exception {
        Server httpServer = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(0);
        httpServer.addConnector((Connector)connector);
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
        TestThriftServletHandler handler = new TestThriftServletHandler(logEntries);
        TestThriftServlet servlet = new TestThriftServlet(handler, logEntries);
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        contextHandler.setContextPath("/thrift");
        contextHandler.addServlet(new ServletHolder((Servlet)servlet), "/*");
        httpServer.setHandler((Handler)contextHandler);
        httpServer.start();
        return httpServer;
    }

    private int getServerPort(Server server) {
        return server.getConnectors()[0].getLocalPort();
    }

    private TestThriftServlet getServerServlet(Server server) throws ServletException {
        ServletContextHandler handler = (ServletContextHandler)server.getHandlers()[0];
        return (TestThriftServlet)handler.getServletHandler().getServlets()[0].getServlet();
    }

    private void shutdownServer(Server httpServer) throws Exception {
        if (httpServer != null) {
            httpServer.stop();
            httpServer.join();
        }
    }

    private class TestThriftServlet
    extends TServlet {
        private final List<LogEntry> logEntries;

        public List<LogEntry> getLogEntries() {
            return this.logEntries;
        }

        public TestThriftServlet(scribe.Iface handler, List<LogEntry> logEntries) {
            super(new scribe.Processor<scribe.Iface>(handler), (TProtocolFactory)new TBinaryProtocol.Factory());
            this.logEntries = logEntries;
        }
    }

    private static class TestThriftServletHandler
    implements scribe.Iface {
        private final List<LogEntry> logEntries;

        private TestThriftServletHandler(List<LogEntry> logEntries) {
            this.logEntries = logEntries;
        }

        @Override
        public ResultCode Log(List<LogEntry> messages) throws TException {
            try {
                Thread.sleep(100L);
                this.logEntries.addAll(messages);
            }
            catch (InterruptedException e) {
                throw new TApplicationException(0);
            }
            return ResultCode.OK;
        }
    }
}

