/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.base;

import com.facebook.nifty.client.FramedClientConnector;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.transport.TTransportException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class SuiteBase<ServiceInterface, ClientInterface> {
    private ThriftCodecManager codecManager = new ThriftCodecManager(new ThriftCodec[0]);
    private ThriftClientManager clientManager;
    private Class<? extends ClientInterface> clientClass;
    private Class<? extends ServiceInterface> handlerClass;
    private ClientInterface client;
    private ThriftServer server;
    private ServiceInterface handler;

    public SuiteBase(Class<? extends ServiceInterface> handlerClass, Class<? extends ClientInterface> clientClass) {
        this.clientClass = clientClass;
        this.handlerClass = handlerClass;
    }

    @BeforeClass
    public void setupSuite() throws InstantiationException, IllegalAccessException {
    }

    @BeforeMethod
    public void setupTest() throws Exception {
        this.handler = this.handlerClass.newInstance();
        this.server = this.createServer(this.handler).start();
        this.clientManager = new ThriftClientManager(this.codecManager);
        this.client = this.createClient(this.clientManager).get();
    }

    @AfterMethod
    public void tearDownTest() throws Exception {
        AutoCloseable closeable = (AutoCloseable)this.client;
        closeable.close();
        this.clientManager.close();
        this.server.close();
    }

    @AfterClass
    public void tearDownSuite() {
    }

    private ThriftServer createServer(ServiceInterface handler) throws IllegalAccessException, InstantiationException {
        ThriftServiceProcessor processor = new ThriftServiceProcessor(this.codecManager, new Object[]{handler});
        return new ThriftServer((TProcessor)processor);
    }

    private ListenableFuture<? extends ClientInterface> createClient(ThriftClientManager clientManager) throws TTransportException, InterruptedException, ExecutionException {
        HostAndPort address = HostAndPort.fromParts((String)"localhost", (int)this.server.getPort());
        return clientManager.createClient((NiftyClientConnector)new FramedClientConnector(address), this.clientClass);
    }

    protected ClientInterface getClient() {
        return this.client;
    }

    protected ServiceInterface getHandler() {
        return this.handler;
    }
}

