/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.exceptions;

import com.facebook.swift.service.base.SuiteBase;
import com.facebook.swift.service.exceptions.ExceptionService;
import com.facebook.swift.service.exceptions.ExceptionServiceClient;
import com.facebook.swift.service.exceptions.ExceptionServiceHandler;
import com.facebook.swift.service.exceptions.NonThriftCheckedException;
import com.facebook.swift.service.exceptions.ThriftCheckedException;
import com.facebook.swift.service.exceptions.ThriftUncheckedException;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.testng.annotations.Test;

public class ExceptionTest
extends SuiteBase<ExceptionService, ExceptionService> {
    public ExceptionTest() {
        super(ExceptionServiceHandler.class, ExceptionServiceClient.class);
    }

    @Test(expectedExceptions={ThriftCheckedException.class})
    public void testThrowExpectedCheckedException() throws ThriftCheckedException, TException {
        ((ExceptionService)this.getClient()).throwExpectedThriftCheckedException();
    }

    @Test(expectedExceptions={ThriftUncheckedException.class})
    public void testThrowExceptedUncheckedException() throws ThriftUncheckedException, TException {
        ((ExceptionService)this.getClient()).throwExpectedThriftUncheckedException();
    }

    @Test(expectedExceptions={TApplicationException.class})
    public void testThrowWrongThriftException() throws TException, ThriftCheckedException {
        ((ExceptionService)this.getClient()).throwWrongThriftException();
    }

    @Test(enabled=false, expectedExceptions={TApplicationException.class})
    public void testThrowUnexpectedThriftCheckedException() throws ThriftCheckedException, TException {
        ((ExceptionService)this.getClient()).throwUnexpectedThriftCheckedException();
    }

    @Test(expectedExceptions={TApplicationException.class})
    public void testThrowUnexpectedThriftUncheckedException() throws TException {
        ((ExceptionService)this.getClient()).throwUnexpectedThriftUncheckedException();
    }

    @Test(expectedExceptions={TApplicationException.class})
    public void testThrowUnexpectedNonThriftCheckedException() throws TException, NonThriftCheckedException {
        ((ExceptionService)this.getClient()).throwUnexpectedNonThriftCheckedException();
    }

    @Test(expectedExceptions={TApplicationException.class})
    public void testThrowUnexpectedNonThriftUncheckedException() throws TException {
        ((ExceptionService)this.getClient()).throwUnexpectedNonThriftUncheckedException();
    }
}

