/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.explicitidentifiers;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.service.ThriftMethod;
import com.facebook.swift.service.ThriftService;
import com.facebook.swift.service.explicitidentifiers.CustomArgument;
import com.google.common.base.Optional;

@ThriftService
public class ExplicitIdentifiersServiceHandler {
    private Object lastStringParam;
    private Object lastBooleanParam;
    private Object lastIntegerParam;
    private Object lastByteParam;
    private Object lastCustomParam;

    private void initializeLastParamValues() {
        this.lastBooleanParam = null;
        this.lastStringParam = null;
        this.lastByteParam = null;
        this.lastCustomParam = null;
        this.lastIntegerParam = null;
    }

    @ThriftMethod
    public void explicitParameterOrdering(@ThriftField(value=20) boolean booleanParam, @ThriftField(value=30) String stringParam, @ThriftField(value=10) int integerParam, @ThriftField(value=40) byte byteParam) {
        this.initializeLastParamValues();
        this.lastBooleanParam = Optional.of((Object)booleanParam);
        this.lastIntegerParam = Optional.of((Object)integerParam);
        this.lastByteParam = Optional.of((Object)byteParam);
        this.lastStringParam = Optional.fromNullable((Object)stringParam);
    }

    @ThriftMethod
    public void missingIncomingParameter(@ThriftField(value=1) int integerParam, @ThriftField(value=2) String stringParam) {
        this.initializeLastParamValues();
        this.lastIntegerParam = Optional.of((Object)integerParam);
        this.lastStringParam = Optional.fromNullable((Object)stringParam);
    }

    @ThriftMethod
    public void extraIncomingParameter(@ThriftField(value=1) int integerParam) {
        this.initializeLastParamValues();
        this.lastIntegerParam = Optional.of((Object)integerParam);
    }

    @ThriftMethod
    public void missingAndReorderedParameters(@ThriftField(value=3) boolean booleanParam, @ThriftField(value=2) String stringParam, @ThriftField(value=1) int integerParam) {
        this.initializeLastParamValues();
        this.lastBooleanParam = Optional.of((Object)booleanParam);
        this.lastIntegerParam = Optional.of((Object)integerParam);
        this.lastStringParam = Optional.fromNullable((Object)stringParam);
    }

    @ThriftMethod
    public void extraAndReorderedParameters(@ThriftField(value=3) boolean booleanParam, @ThriftField(value=2) String stringParam) {
        this.initializeLastParamValues();
        this.lastBooleanParam = Optional.of((Object)booleanParam);
        this.lastStringParam = Optional.fromNullable((Object)stringParam);
    }

    @ThriftMethod
    public void missingInteger(@ThriftField(value=1) int integerParam) {
        this.initializeLastParamValues();
        this.lastIntegerParam = Optional.of((Object)integerParam);
    }

    @ThriftMethod
    public void missingStruct(@ThriftField(value=1) CustomArgument customParam) {
        this.initializeLastParamValues();
        this.lastCustomParam = Optional.fromNullable((Object)customParam);
    }

    @ThriftMethod
    public void extraStruct() {
        this.initializeLastParamValues();
    }

    public boolean hasLastBooleanParam() {
        return this.lastBooleanParam != null;
    }

    public boolean hasLastStringParam() {
        return this.lastStringParam != null;
    }

    public boolean hasLastIntegerParam() {
        return this.lastIntegerParam != null;
    }

    public boolean hasLastByteParam() {
        return this.lastByteParam != null;
    }

    public boolean hasLastCustomParam() {
        return this.lastCustomParam != null;
    }

    public Optional<Boolean> getLastBooleanParam() {
        return (Optional)this.lastBooleanParam;
    }

    public Optional<String> getLastStringParam() {
        return (Optional)this.lastStringParam;
    }

    public Optional<Integer> getLastIntegerParam() {
        return (Optional)this.lastIntegerParam;
    }

    public Optional<Byte> getLastByteParam() {
        return (Optional)this.lastByteParam;
    }

    public Optional<CustomArgument> getLastCustomParam() {
        return (Optional)this.lastCustomParam;
    }

    public void setLastBooleanParam(boolean lastBooleanParam) {
        this.lastBooleanParam = Optional.of((Object)lastBooleanParam);
    }

    public void setLastIntegerParam(int lastIntegerParam) {
        this.lastIntegerParam = Optional.of((Object)lastIntegerParam);
    }

    public void setLastByteParam(byte lastByteParam) {
        this.lastByteParam = Optional.of((Object)lastByteParam);
    }

    public void setLastStringParam(String lastStringParam) {
        this.lastStringParam = Optional.fromNullable((Object)lastStringParam);
    }

    public void setLastCustomParam(CustomArgument lastCustomParam) {
        this.lastCustomParam = Optional.fromNullable((Object)lastCustomParam);
    }
}

