/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.guice;

import com.facebook.nifty.client.FramedClientConnector;
import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.swift.codec.guice.ThriftCodecModule;
import com.facebook.swift.service.LogEntry;
import com.facebook.swift.service.ResultCode;
import com.facebook.swift.service.Scribe;
import com.facebook.swift.service.SwiftScribe;
import com.facebook.swift.service.ThriftClient;
import com.facebook.swift.service.ThriftClientConfig;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.guice.ThriftClientBinder;
import com.facebook.swift.service.guice.ThriftClientModule;
import com.facebook.swift.service.guice.ThriftServerModule;
import com.facebook.swift.service.guice.ThriftServiceExporter;
import com.facebook.swift.service.puma.TestPuma;
import com.facebook.swift.service.puma.swift.PumaReadServer;
import com.facebook.swift.service.puma.swift.PumaReadService;
import com.facebook.swift.service.puma.swift.ReadQueryInfoTimeString;
import com.facebook.swift.service.puma.swift.ReadResultQueryInfoTimeString;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.jmx.JmxModule;
import io.airlift.units.Duration;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.weakref.jmx.guice.MBeanModule;

public class TestThriftClientAndServerModules {
    private static final List<LogEntry> MESSAGES = ImmutableList.of((Object)new LogEntry("hello", "world"), (Object)new LogEntry("bye", "world"));

    @Test
    public void testThriftClientAndServerModules() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new ThriftCodecModule(), new ThriftClientModule(), new ThriftServerModule(), new JmxModule(), new MBeanModule(), new Module(){

            public void configure(Binder binder) {
                ThriftClientBinder.thriftClientBinder((Binder)binder).bindThriftClient(Scribe.class);
                binder.bind(SwiftScribe.class).in(Scopes.SINGLETON);
                ThriftServiceExporter.thriftServerBinder((Binder)binder).exportThriftService(SwiftScribe.class);
                ThriftClientBinder.thriftClientBinder((Binder)binder).bindThriftClient(PumaReadService.class);
                binder.bind(PumaReadServer.class).in(Scopes.SINGLETON);
                ThriftServiceExporter.thriftServerBinder((Binder)binder).exportThriftService(PumaReadServer.class);
            }
        }});
        try (ThriftServer server = ((ThriftServer)injector.getInstance(ThriftServer.class)).start();){
            ThriftClient scribeClient = (ThriftClient)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftClient<Scribe>>(){}));
            try (Scribe scribe2 = (Scribe)scribeClient.open(this.localFramedConnector(server.getPort())).get();){
                Assert.assertEquals((Object)((Object)scribe2.log(MESSAGES)), (Object)((Object)ResultCode.OK));
                Assert.assertEquals(((SwiftScribe)injector.getInstance(SwiftScribe.class)).getMessages(), (Collection)Lists.newArrayList(MESSAGES));
            }
            ThriftClient pumaClient = (ThriftClient)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftClient<PumaReadService>>(){}));
            try (PumaReadService puma = (PumaReadService)pumaClient.open(this.localFramedConnector(server.getPort())).get();){
                List<ReadResultQueryInfoTimeString> results = puma.getResultTimeString((List<ReadQueryInfoTimeString>)TestPuma.PUMA_REQUEST);
                TestPuma.verifyPumaResults(results);
            }
        }
    }

    @Test
    public void testThriftWithAnnotationBinding() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new ThriftCodecModule(), new ThriftClientModule(), new ThriftServerModule(), new Module(){

            public void configure(Binder binder) {
                ThriftClientBinder.thriftClientBinder((Binder)binder).bindThriftClient(Scribe.class, TestAnnotation.class);
                binder.bind(SwiftScribe.class).annotatedWith(TestAnnotation.class).to(SwiftScribe.class).in(Scopes.SINGLETON);
                ThriftServiceExporter.thriftServerBinder((Binder)binder).exportThriftService(SwiftScribe.class, TestAnnotation.class);
                ThriftClientBinder.thriftClientBinder((Binder)binder).bindThriftClient(PumaReadService.class, TestAnnotation.class);
                binder.bind(PumaReadServer.class).annotatedWith(TestAnnotation.class).to(PumaReadServer.class).in(Scopes.SINGLETON);
                ThriftServiceExporter.thriftServerBinder((Binder)binder).exportThriftService(PumaReadServer.class, TestAnnotation.class);
            }
        }});
        try (ThriftServer server = ((ThriftServer)injector.getInstance(ThriftServer.class)).start();){
            ThriftClient scribeClient = (ThriftClient)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftClient<Scribe>>(){}, TestAnnotation.class));
            try (Scribe scribe2 = (Scribe)scribeClient.open(this.localFramedConnector(server.getPort())).get();){
                Assert.assertEquals((Object)((Object)scribe2.log(MESSAGES)), (Object)((Object)ResultCode.OK));
                Assert.assertEquals(((SwiftScribe)injector.getInstance(Key.get(SwiftScribe.class, TestAnnotation.class))).getMessages(), (Collection)Lists.newArrayList(MESSAGES));
            }
            ThriftClient pumaClient = (ThriftClient)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftClient<PumaReadService>>(){}, TestAnnotation.class));
            try (PumaReadService puma = (PumaReadService)pumaClient.open(this.localFramedConnector(server.getPort())).get();){
                List<ReadResultQueryInfoTimeString> results = puma.getResultTimeString((List<ReadQueryInfoTimeString>)TestPuma.PUMA_REQUEST);
                TestPuma.verifyPumaResults(results);
            }
        }
    }

    @Test
    public void testThriftWithKeyBinding() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new ThriftCodecModule(), new ThriftClientModule(), new ThriftServerModule(), new Module(){

            public void configure(Binder binder) {
                ThriftClientBinder.thriftClientBinder((Binder)binder).bindThriftClient(Scribe.class);
                binder.bind(SwiftScribe.class).annotatedWith(TestAnnotation.class).to(SwiftScribe.class).in(Scopes.SINGLETON);
                ThriftServiceExporter.thriftServerBinder((Binder)binder).exportThriftService(Key.get(SwiftScribe.class, TestAnnotation.class));
                ThriftClientBinder.thriftClientBinder((Binder)binder).bindThriftClient(PumaReadService.class);
                binder.bind(PumaReadServer.class).annotatedWith(TestAnnotation.class).to(PumaReadServer.class).in(Scopes.SINGLETON);
                ThriftServiceExporter.thriftServerBinder((Binder)binder).exportThriftService(Key.get(PumaReadServer.class, TestAnnotation.class));
            }
        }});
        try (ThriftServer server = ((ThriftServer)injector.getInstance(ThriftServer.class)).start();){
            ThriftClient scribeClient = (ThriftClient)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftClient<Scribe>>(){}));
            try (Scribe scribe2 = (Scribe)scribeClient.open(this.localFramedConnector(server.getPort())).get();){
                Assert.assertEquals((Object)((Object)scribe2.log(MESSAGES)), (Object)((Object)ResultCode.OK));
                Assert.assertEquals(((SwiftScribe)injector.getInstance(Key.get(SwiftScribe.class, TestAnnotation.class))).getMessages(), (Collection)Lists.newArrayList(MESSAGES));
            }
            ThriftClient pumaClient = (ThriftClient)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftClient<PumaReadService>>(){}));
            try (PumaReadService puma = (PumaReadService)pumaClient.open(this.localFramedConnector(server.getPort())).get();){
                List<ReadResultQueryInfoTimeString> results = puma.getResultTimeString((List<ReadQueryInfoTimeString>)TestPuma.PUMA_REQUEST);
                TestPuma.verifyPumaResults(results);
            }
        }
    }

    @Test
    public void testThriftClientWithConfiguration() throws Exception {
        String SOCKS_PROXY_HOSTNAME = "proxyserver";
        int SOCKS_PROXY_PORT = 1080;
        int SIXTEEN_MB_IN_BYTES = 0x1000000;
        String TEST_MEDIUM_TIMEOUT = "1s";
        String TEST_SHORT_TIMEOUT = "150ms";
        String TEST_LONG_TIMEOUT = "1m";
        HostAndPort proxy = HostAndPort.fromParts((String)"proxyserver", (int)1080);
        ImmutableMap configMap = new ImmutableMap.Builder().put((Object)"scribe.thrift.client.connect-timeout", (Object)"1s").put((Object)"scribe.thrift.client.read-timeout", (Object)"150ms").put((Object)"scribe.thrift.client.max-frame-size", (Object)Integer.toString(0x1000000)).put((Object)"PumaReadService.thrift.client.write-timeout", (Object)"1m").put((Object)"PumaReadService.thrift.client.socks-proxy", (Object)proxy.toString()).build();
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)configMap)), new ThriftCodecModule(), new ThriftClientModule(), new Module(){

            public void configure(Binder binder) {
                ThriftClientBinder.thriftClientBinder((Binder)binder).bindThriftClient(Scribe.class);
                ThriftClientBinder.thriftClientBinder((Binder)binder).bindThriftClient(PumaReadService.class);
            }
        }});
        ThriftClient scribeClient = (ThriftClient)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftClient<Scribe>>(){}));
        Assert.assertEquals((Object)Duration.valueOf((String)scribeClient.getConnectTimeout()), (Object)Duration.valueOf((String)"1s"));
        Assert.assertEquals((Object)Duration.valueOf((String)scribeClient.getReadTimeout()), (Object)Duration.valueOf((String)"150ms"));
        Assert.assertEquals((Object)Duration.valueOf((String)scribeClient.getWriteTimeout()), (Object)ThriftClientConfig.DEFAULT_WRITE_TIMEOUT);
        Assert.assertEquals((int)scribeClient.getMaxFrameSize(), (int)0x1000000);
        Assert.assertEquals((String)scribeClient.getSocksProxy(), null);
        ThriftClient pumaClient = (ThriftClient)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftClient<PumaReadService>>(){}));
        Assert.assertEquals((Object)Duration.valueOf((String)pumaClient.getConnectTimeout()), (Object)ThriftClientConfig.DEFAULT_CONNECT_TIMEOUT);
        Assert.assertEquals((Object)Duration.valueOf((String)pumaClient.getReadTimeout()), (Object)ThriftClientConfig.DEFAULT_READ_TIMEOUT);
        Assert.assertEquals((Object)Duration.valueOf((String)pumaClient.getWriteTimeout()), (Object)Duration.valueOf((String)"1m"));
        Assert.assertEquals((int)pumaClient.getMaxFrameSize(), (int)0x1000000);
        Assert.assertEquals((Object)HostAndPort.fromString((String)pumaClient.getSocksProxy()), (Object)proxy);
    }

    private NiftyClientConnector<? extends NiftyClientChannel> localFramedConnector(int port) {
        return new FramedClientConnector(HostAndPort.fromParts((String)"localhost", (int)port));
    }

    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    public static @interface TestAnnotation {
    }
}

