/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.metadata;

import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.service.ThriftException;
import com.facebook.swift.service.ThriftMethod;
import com.facebook.swift.service.metadata.ThriftMethodMetadata;
import java.util.Map;
import java.util.TreeMap;
import org.apache.thrift.TException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftMethodMetadata {
    @Test
    public void testNoExceptions() throws Exception {
        this.assertExceptions("noExceptions", new Class[0]);
    }

    @Test
    public void testAnnotatedExceptions() throws Exception {
        this.assertExceptions("annotatedExceptions", ExceptionA.class, ExceptionB.class);
    }

    @Test
    public void testInferredException() throws Exception {
        this.assertExceptions("inferredException", ExceptionA.class);
    }

    @Test
    public void testInferredExceptionWithTException() throws Exception {
        this.assertExceptions("inferredExceptionWithTException", ExceptionA.class);
    }

    @Test
    public void testInferredExceptionWithRuntimeException() throws Exception {
        this.assertExceptions("inferredExceptionWithRuntimeException", ExceptionA.class);
    }

    @Test
    public void testInferredExceptionWithRuntimeAndTException() throws Exception {
        this.assertExceptions("inferredExceptionWithRuntimeAndTException", ExceptionA.class);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ThriftMethod.exception annotation value must be specified when more than one custom exception is thrown.")
    public void testUninferrableException() throws Exception {
        this.assertExceptions("uninferrableException", new Class[0]);
    }

    private void assertExceptions(String methodName, Class<? extends Exception> ... expectedExceptions) throws Exception {
        ThriftMethodMetadata metadata = new ThriftMethodMetadata(DummyService.class.getMethod(methodName, new Class[0]), new ThriftCatalog());
        TreeMap actualIdMap = new TreeMap();
        TreeMap<Short, Class<? extends Exception>> expectedIdMap = new TreeMap<Short, Class<? extends Exception>>();
        for (Map.Entry entry : metadata.getExceptions().entrySet()) {
            actualIdMap.put(entry.getKey(), ((ThriftType)entry.getValue()).getJavaType());
        }
        short expectedId = 1;
        for (Class<? extends Exception> expectedException : expectedExceptions) {
            expectedIdMap.put(expectedId, expectedException);
            expectedId = (short)(expectedId + 1);
        }
        Assert.assertEquals((String)((Object)actualIdMap).toString(), (String)((Object)expectedIdMap).toString());
    }

    @ThriftStruct
    public static class ExceptionB
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    @ThriftStruct
    public static class ExceptionA
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static interface DummyService {
        @ThriftMethod
        public void noExceptions();

        @ThriftMethod(exception={@ThriftException(id=1, type=ExceptionA.class), @ThriftException(id=2, type=ExceptionB.class)})
        public void annotatedExceptions() throws ExceptionA, ExceptionB;

        @ThriftMethod
        public void inferredException() throws ExceptionA;

        @ThriftMethod
        public void inferredExceptionWithTException() throws ExceptionA, TException;

        @ThriftMethod
        public void inferredExceptionWithRuntimeException() throws IllegalArgumentException, ExceptionA;

        @ThriftMethod
        public void inferredExceptionWithRuntimeAndTException() throws IllegalArgumentException, ExceptionA, TException;

        @ThriftMethod(exception={@ThriftException(id=1, type=ExceptionA.class)})
        public void uninferrableException() throws ExceptionA, ExceptionB;
    }
}

