/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.protocol;

import com.facebook.nifty.client.FramedClientConnector;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.core.NettyConfigBuilder;
import com.facebook.nifty.core.NettyServerTransport;
import com.facebook.nifty.core.ThriftServerDef;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.LogEntry;
import com.facebook.swift.service.ResultCode;
import com.facebook.swift.service.Scribe;
import com.facebook.swift.service.ThriftClient;
import com.facebook.swift.service.ThriftClientConfig;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.ThriftMethod;
import com.facebook.swift.service.ThriftService;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.testng.annotations.Test;

public class TestClientProtocols {
    @Test
    public void testBinaryProtocolClient() throws Exception {
        try (ScopedServer server = new ScopedServer((TProtocolFactory)new TBinaryProtocol.Factory());
             ThriftClientManager manager = new ThriftClientManager();
             Scribe client = this.createScribeClient(manager, server, (TProtocolFactory)new TBinaryProtocol.Factory());){
            client.log((List<LogEntry>)ImmutableList.of((Object)new LogEntry("testCategory1", "testMessage1"), (Object)new LogEntry("testCategory2", "testMessage2")));
        }
    }

    @Test
    public void testCompactProtocolClient() throws Exception {
        try (ScopedServer server = new ScopedServer((TProtocolFactory)new TCompactProtocol.Factory());
             ThriftClientManager manager = new ThriftClientManager();
             Scribe client = this.createScribeClient(manager, server, (TProtocolFactory)new TCompactProtocol.Factory());){
            client.log((List<LogEntry>)ImmutableList.of((Object)new LogEntry("testCategory1", "testMessage1"), (Object)new LogEntry("testCategory2", "testMessage2")));
        }
    }

    @Test(expectedExceptions={TTransportException.class})
    public void testUnmatchedProtocols() throws Exception {
        try (ScopedServer server = new ScopedServer((TProtocolFactory)new TCompactProtocol.Factory());
             ThriftClientManager manager = new ThriftClientManager();
             Scribe client = this.createScribeClient(manager, server, (TProtocolFactory)new TBinaryProtocol.Factory());){
            client.log((List<LogEntry>)ImmutableList.of((Object)new LogEntry("testCategory1", "testMessage1"), (Object)new LogEntry("testCategory2", "testMessage2")));
        }
    }

    private Scribe createScribeClient(ThriftClientManager manager, ScopedServer server, TProtocolFactory protocolFactory) throws ExecutionException, InterruptedException, TException {
        ThriftClientConfig config = new ThriftClientConfig().setConnectTimeout(Duration.valueOf((String)"1s")).setReadTimeout(Duration.valueOf((String)"1s")).setWriteTimeout(Duration.valueOf((String)"1s"));
        ThriftClient thriftClient = new ThriftClient(manager, Scribe.class, config, "ScribeClient");
        return (Scribe)thriftClient.open((NiftyClientConnector)new FramedClientConnector(HostAndPort.fromParts((String)"localhost", (int)server.getPort()), TDuplexProtocolFactory.fromSingleFactory((TProtocolFactory)protocolFactory))).get();
    }

    private class ScopedServer
    implements AutoCloseable {
        private final NettyServerTransport server;

        public ScopedServer(TProtocolFactory protocolFactory) throws TTransportException, InterruptedException {
            ThriftServiceProcessor processor = new ThriftServiceProcessor(new ThriftCodecManager(new ThriftCodec[0]), new Object[]{new ScribeHandler()});
            ThriftServerDef def = ThriftServerDef.newBuilder().listen(0).withProcessor((TProcessor)processor).speaks(protocolFactory).build();
            this.server = new NettyServerTransport(def, new NettyConfigBuilder(), (ChannelGroup)new DefaultChannelGroup(), (Timer)new HashedWheelTimer());
            this.server.start();
        }

        public int getPort() {
            InetSocketAddress address = (InetSocketAddress)this.server.getServerChannel().getLocalAddress();
            return address.getPort();
        }

        @Override
        public void close() throws Exception {
            this.server.stop();
        }
    }

    @ThriftService
    public class ScribeHandler {
        @ThriftMethod(value="Log")
        public ResultCode log(List<LogEntry> messages) {
            return ResultCode.OK;
        }
    }
}

