/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.puma;

import com.facebook.nifty.client.FramedClientConnector;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.facebook.swift.service.puma.swift.PumaReadServer;
import com.facebook.swift.service.puma.swift.PumaReadService;
import com.facebook.swift.service.puma.swift.ReadQueryInfoTimeString;
import com.facebook.swift.service.puma.swift.ReadResultQueryInfoTimeString;
import com.facebook.swift.service.puma.swift.ReadSemanticException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TProcessor;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPuma {
    public static final ImmutableList<ReadQueryInfoTimeString> PUMA_REQUEST = ImmutableList.of((Object)new ReadQueryInfoTimeString("foo", "now", "later", 42, (Map<String, String>)ImmutableMap.of((Object)"a", (Object)"b"), (List<String>)ImmutableList.of((Object)"apple", (Object)"banana")), (Object)new ReadQueryInfoTimeString("bar", "snack", "attack", 33, (Map<String, String>)ImmutableMap.of((Object)"c", (Object)"d"), (List<String>)ImmutableList.of((Object)"cheetos", (Object)"doritos")));

    @Test
    public void testPumaDirect() throws Exception {
        PumaReadServer puma = new PumaReadServer();
        List<ReadResultQueryInfoTimeString> results = puma.getResultTimeString((List<ReadQueryInfoTimeString>)PUMA_REQUEST);
        TestPuma.verifyPumaResults(results);
    }

    @Test
    public void testPumaSwift() throws Exception {
        PumaReadServer puma = new PumaReadServer();
        ThriftServiceProcessor processor = new ThriftServiceProcessor(new ThriftCodecManager(new ThriftCodec[0]), new Object[]{puma});
        try (ThriftServer server = new ThriftServer((TProcessor)processor).start();
             ThriftClientManager clientManager = new ThriftClientManager();
             PumaReadService pumaClient = (PumaReadService)clientManager.createClient((NiftyClientConnector)new FramedClientConnector(HostAndPort.fromParts((String)"localhost", (int)server.getPort())), PumaReadService.class).get();){
            List<ReadResultQueryInfoTimeString> results = pumaClient.getResultTimeString((List<ReadQueryInfoTimeString>)PUMA_REQUEST);
            TestPuma.verifyPumaResults(results);
        }
    }

    @Test
    public void testPumaDirectException() throws Exception {
        PumaReadServer puma = new PumaReadServer();
        ReadSemanticException exception = new ReadSemanticException("my exception");
        puma.setException(exception);
        try {
            puma.getResultTimeString((List<ReadQueryInfoTimeString>)PUMA_REQUEST);
            Assert.fail((String)"Expected ReadSemanticException");
        }
        catch (ReadSemanticException e) {
            Assert.assertEquals((Object)e, (Object)exception);
        }
    }

    @Test
    public void testPumaSwiftException() throws Exception {
        PumaReadServer puma = new PumaReadServer();
        ReadSemanticException exception = new ReadSemanticException("my exception");
        puma.setException(exception);
        ThriftServiceProcessor processor = new ThriftServiceProcessor(new ThriftCodecManager(new ThriftCodec[0]), new Object[]{puma});
        try (ThriftServer server = new ThriftServer((TProcessor)processor).start();
             ThriftClientManager clientManager = new ThriftClientManager();
             PumaReadService pumaClient = (PumaReadService)clientManager.createClient((NiftyClientConnector)new FramedClientConnector(HostAndPort.fromParts((String)"localhost", (int)server.getPort())), PumaReadService.class).get();){
            pumaClient.getResultTimeString((List<ReadQueryInfoTimeString>)PUMA_REQUEST);
            Assert.fail((String)"Expected ReadSemanticException");
        }
        catch (ReadSemanticException e) {
            Assert.assertEquals((Object)e, (Object)exception);
        }
    }

    public static void verifyPumaResults(List<ReadResultQueryInfoTimeString> results) {
        ((ListAssert)((ListAssert)Assertions.assertThat(results).as("results")).hasSize(2)).containsSequence(new Object[]{new ReadResultQueryInfoTimeString("now", (Map<String, String>)ImmutableMap.of((Object)"apple", (Object)"apple", (Object)"banana", (Object)"banana")), new ReadResultQueryInfoTimeString("snack", (Map<String, String>)ImmutableMap.of((Object)"cheetos", (Object)"cheetos", (Object)"doritos", (Object)"doritos"))});
    }
}

