/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service.unframed;

import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.client.UnframedClientConnector;
import com.facebook.swift.service.LogEntry;
import com.facebook.swift.service.ResultCode;
import com.facebook.swift.service.Scribe;
import com.facebook.swift.service.ThriftClientManager;
import com.facebook.swift.service.async.AsyncScribe;
import com.facebook.swift.service.scribe.scribe;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.thrift.TException;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnframedTest {
    @Test
    public void testUnframedSyncMethod() throws Exception {
        TestServerInfo info = this.startServer();
        ThriftClientManager clientManager = new ThriftClientManager();
        try (Scribe client = (Scribe)this.createUnframedClient(clientManager, Scribe.class, info.port).get();){
            ResultCode result = client.log(Lists.newArrayList((Object[])new LogEntry[]{new LogEntry("testCategory", "testMessage")}));
            Assert.assertEquals((Object)((Object)result), (Object)((Object)ResultCode.OK));
        }
        this.stopServer(info);
    }

    @Test
    public void testUnframedAsyncMethod() throws Exception {
        TestServerInfo info = this.startServer();
        ThriftClientManager clientManager = new ThriftClientManager();
        final CountDownLatch latch = new CountDownLatch(1);
        final ResultCode[] resultHolder = new ResultCode[1];
        ListenableFuture<AsyncScribe> clientFuture = this.createUnframedClient(clientManager, AsyncScribe.class, info.port);
        Futures.addCallback(clientFuture, (FutureCallback)new FutureCallback<AsyncScribe>(){

            public void onSuccess(AsyncScribe client) {
                try {
                    ListenableFuture<ResultCode> methodFuture = client.log(Lists.newArrayList((Object[])new LogEntry[]{new LogEntry("testCategory", "testMessage")}));
                    Futures.addCallback(methodFuture, (FutureCallback)new FutureCallback<ResultCode>(){

                        public void onSuccess(ResultCode result) {
                            resultHolder[0] = result;
                            latch.countDown();
                        }

                        public void onFailure(Throwable t) {
                            latch.countDown();
                        }
                    });
                }
                catch (TException e) {
                    latch.countDown();
                }
            }

            public void onFailure(Throwable t) {
                latch.countDown();
            }
        });
        latch.await();
        this.stopServer(info);
    }

    private <T> ListenableFuture<T> createUnframedClient(ThriftClientManager clientManager, Class<T> clientType, int servicePort) throws Exception {
        return clientManager.createClient((NiftyClientConnector)new UnframedClientConnector(HostAndPort.fromParts((String)"localhost", (int)servicePort)), clientType);
    }

    public TestServerInfo startServer() throws Exception {
        TestServerInfo info = new TestServerInfo();
        TServerSocket serverSocket = new TServerSocket(0);
        PlainScribeHandler handler = new PlainScribeHandler();
        scribe.Processor<PlainScribeHandler> processor = new scribe.Processor<PlainScribeHandler>(handler);
        TThreadPoolServer.Args args = (TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverSocket).processor(processor);
        info.server = new TThreadPoolServer(args);
        TThreadPoolServer thriftServer = info.server;
        new Thread((TServer)thriftServer){
            final /* synthetic */ TServer val$thriftServer;
            {
                this.val$thriftServer = tServer;
            }

            @Override
            public void run() {
                this.val$thriftServer.serve();
            }
        }.start();
        while (!info.server.isServing()) {
            Thread.sleep(10L);
        }
        info.port = serverSocket.getServerSocket().getLocalPort();
        return info;
    }

    public void stopServer(TestServerInfo info) throws Exception {
        info.server.stop();
    }

    private class TestServerInfo {
        public TServer server;
        public int port;

        private TestServerInfo() {
        }
    }

    private class PlainScribeHandler
    implements scribe.Iface {
        private PlainScribeHandler() {
        }

        @Override
        public com.facebook.swift.service.scribe.ResultCode Log(List<com.facebook.swift.service.scribe.LogEntry> messages) throws TException {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return com.facebook.swift.service.scribe.ResultCode.TRY_LATER;
            }
            return com.facebook.swift.service.scribe.ResultCode.OK;
        }
    }
}

