/*
 * Decompiled with CFR 0.152.
 */
package com.fastchar.sms;

import com.fastchar.core.FastChar;
import com.fastchar.core.FastHandler;
import com.fastchar.sms.FastSMSConfig;
import com.fastchar.sms.entity.FinalSmsEntity;
import com.fastchar.sms.exception.FastSMSException;
import com.fastchar.sms.interfaces.IFastSMSInterface;
import com.fastchar.utils.FastNumberUtils;
import com.fastchar.utils.FastStringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastSMS {
    private String configOnlyCode;
    private String phone;
    private String type;
    private Map<String, Object> params = new LinkedHashMap<String, Object>();

    public static FastSMS getInstance() {
        return (FastSMS)FastChar.getOverrides().newInstance(FastSMS.class, new Object[0]);
    }

    private FastSMS() {
    }

    public String getConfigOnlyCode() {
        return this.configOnlyCode;
    }

    public FastSMS setConfigOnlyCode(String configOnlyCode) {
        this.configOnlyCode = configOnlyCode;
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public FastSMS setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public FastSMS setType(String type) {
        this.type = type;
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public FastSMS addParams(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    private void validPhone() {
        if (FastStringUtils.isEmpty((CharSequence)this.phone)) {
            throw new FastSMSException("\u624b\u673a\u53f7\u7801phone\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
    }

    private void validType() {
        if (FastStringUtils.isEmpty((CharSequence)this.type)) {
            throw new FastSMSException("\u77ed\u4fe1\u7c7b\u578btype\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
    }

    private void validTemplate() {
        FastSMSConfig config = (FastSMSConfig)FastChar.getConfig((String)this.getConfigOnlyCode(), FastSMSConfig.class);
        if (FastStringUtils.isEmpty((CharSequence)config.getTemplate(this.type))) {
            throw new FastSMSException(MessageFormat.format("\u77ed\u4fe1\u7c7b\u578b{0}\u7684\u6a21\u677f\u4e0d\u5b58\u5728\uff01", this.type));
        }
    }

    private List<String> getKeys(String content) {
        ArrayList<String> keys = new ArrayList<String>();
        String regStr = "\\{([^{}]*)}";
        Pattern compile = Pattern.compile(regStr);
        Matcher matcher = compile.matcher(content);
        while (matcher.find()) {
            keys.add(matcher.group(1));
        }
        return keys;
    }

    private String replaceHolder(String content, Map<String, Object> params) {
        List<String> keys = this.getKeys(content);
        for (String key : keys) {
            String value = "";
            if (params.containsKey(key)) {
                value = String.valueOf(params.get(key));
            }
            String keyModule = "\\{" + key + "}";
            content = content.replaceAll(keyModule, value);
        }
        return content;
    }

    private FastHandler validMaxCount() {
        FastHandler handler = new FastHandler();
        handler.setCode(0);
        FastSMSConfig config = (FastSMSConfig)FastChar.getConfig((String)this.getConfigOnlyCode(), FastSMSConfig.class);
        if (FastChar.getDatabases().hasDatabase() && !config.isDebug()) {
            int countDaySend = FinalSmsEntity.dao().countDaySend(this.phone, this.type);
            if (config.getMaxCountByDay(this.type) > 0 && countDaySend >= config.getMaxCountByDay(this.type)) {
                handler.setCode(-1);
                handler.setError("\u60a8\u64cd\u4f5c\u592a\u9891\u7e41\u4e86\uff0c\u8bf7\u660e\u5929\u91cd\u65b0\u5c1d\u8bd5\uff01");
            }
        }
        return handler;
    }

    public FastHandler sendCode() {
        FastSMSConfig config = (FastSMSConfig)FastChar.getConfig((String)this.getConfigOnlyCode(), FastSMSConfig.class);
        StringBuilder maxBuilder = new StringBuilder("9");
        StringBuilder minBuilder = new StringBuilder("1");
        for (int i = 0; i < config.getCodeLength() - 1; ++i) {
            maxBuilder.append("9");
            minBuilder.append("0");
        }
        int max = FastNumberUtils.formatToInt((Object)maxBuilder.toString());
        int min = FastNumberUtils.formatToInt((Object)minBuilder.toString());
        Random random = new Random();
        int code = random.nextInt(max) % (max - min + 1) + min;
        this.params.put("code", String.valueOf(code));
        return this.send();
    }

    public FastHandler send() {
        this.validPhone();
        this.validType();
        this.validTemplate();
        FastSMSConfig config = (FastSMSConfig)FastChar.getConfig((String)this.getConfigOnlyCode(), FastSMSConfig.class);
        FastHandler validMaxCount = this.validMaxCount();
        if (validMaxCount.getCode() != 0) {
            return validMaxCount;
        }
        String template = config.getTemplate(this.type);
        String content = this.replaceHolder(template, this.params);
        FinalSmsEntity finalSmsEntity = FinalSmsEntity.newInstance();
        finalSmsEntity.put("sendPhone", this.phone);
        finalSmsEntity.put("sendType", this.type);
        finalSmsEntity.put("sendContent", content);
        finalSmsEntity.put("sendParams", FastChar.getJson().toJson(this.params));
        if (config.isDebug()) {
            finalSmsEntity.put("sendResult", "\u8c03\u8bd5\u6a21\u5f0f\uff0c\u9ed8\u8ba4\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01");
            finalSmsEntity.save();
            FastChar.getLog().info(finalSmsEntity.toJson());
            if (this.params.containsKey("code")) {
                return new FastHandler().setCode(0).setError("\u8c03\u8bd5\u6a21\u5f0f\uff0c\u9ed8\u8ba4\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01" + this.params.get("code"));
            }
            return new FastHandler().setCode(0).setError("\u8c03\u8bd5\u6a21\u5f0f\uff0c\u9ed8\u8ba4\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01");
        }
        IFastSMSInterface iFastSMSInterface = (IFastSMSInterface)FastChar.getOverrides().singleInstance(IFastSMSInterface.class, new Object[0]);
        FastHandler handler = iFastSMSInterface.postSMS(finalSmsEntity);
        if (handler.getCode() == 0 && FastChar.getDatabases().hasDatabase()) {
            finalSmsEntity.put("sendResult", handler.getError());
            finalSmsEntity.save();
        }
        return handler;
    }

    public FastHandler validCode(int code) {
        this.validPhone();
        this.validType();
        FastHandler handler = new FastHandler();
        FastSMSConfig config = (FastSMSConfig)FastChar.getConfig((String)this.getConfigOnlyCode(), FastSMSConfig.class);
        FinalSmsEntity smsEntity = FinalSmsEntity.dao().getSmsEntity(this.type, this.phone);
        if (smsEntity == null) {
            handler.setCode(-1);
            handler.setError("\u8bf7\u60a8\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801\uff01");
            return handler;
        }
        Map sendParams = smsEntity.getSendParams();
        if (!sendParams.containsKey("code")) {
            handler.setCode(-1);
            handler.setError("\u8bf7\u60a8\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801\uff01");
            return handler;
        }
        int sendCode = FastNumberUtils.formatToInt(sendParams.get("code"));
        int maxSecond = config.getMaxSecondByValid(this.type);
        if (maxSecond > -1) {
            Date sendDateTime = smsEntity.getSendDateTime();
            long timeSpan = System.currentTimeMillis() - sendDateTime.getTime();
            if (timeSpan > (long)(maxSecond * 1000)) {
                handler.setCode(-2);
                handler.setError("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u60a8\u91cd\u65b0\u83b7\u53d6\uff01");
                return handler;
            }
        }
        if (sendCode != code) {
            handler.setCode(-3);
            handler.setError("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u60a8\u91cd\u65b0\u8f93\u5165\uff01");
            return handler;
        }
        if (FastChar.getDatabases().hasDatabase()) {
            if (smsEntity.delete(new String[]{"sendPhone", "sendType"})) {
                handler.setCode(0);
                handler.setError("\u6709\u6548\u9a8c\u8bc1\u7801\uff01");
            } else {
                handler.setCode(-9);
                handler.setError(smsEntity.getError());
            }
        } else {
            handler.setCode(0);
            handler.setError("\u6709\u6548\u9a8c\u8bc1\u7801\uff01");
        }
        return handler;
    }
}

