/*
 * Decompiled with CFR 0.152.
 */
package com.fastchar.sms;

import com.fastchar.interfaces.IFastConfig;
import com.fastchar.utils.FastStringUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class FastSMSConfig
implements IFastConfig {
    private Map<String, String> template = new LinkedHashMap<String, String>();
    private Map<String, Integer> maxCountByDay = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> maxSecondByValid = new LinkedHashMap<String, Integer>();
    private int codeLength = 6;
    private boolean debug;

    public String getTemplate(String type) {
        for (String key : this.template.keySet()) {
            if (!FastStringUtils.matches((String)key, (String)type)) continue;
            return this.template.get(key);
        }
        return this.template.get(type);
    }

    public FastSMSConfig setTemplate(String typePattern, String template) {
        this.template.put(typePattern, template);
        return this;
    }

    public FastSMSConfig setMaxCountByDay(String typePattern, int maxCount) {
        this.maxCountByDay.put(typePattern, maxCount);
        return this;
    }

    public int getMaxCountByDay(String type) {
        for (String key : this.maxCountByDay.keySet()) {
            if (!FastStringUtils.matches((String)key, (String)type)) continue;
            return this.maxCountByDay.get(key);
        }
        return -1;
    }

    public int getMaxSecondByValid(String type) {
        for (String key : this.maxSecondByValid.keySet()) {
            if (!FastStringUtils.matches((String)key, (String)type)) continue;
            return this.maxSecondByValid.get(key);
        }
        return -1;
    }

    public FastSMSConfig setMaxSecondByValid(String typePattern, int maxSecond) {
        this.maxSecondByValid.put(typePattern, maxSecond);
        return this;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public FastSMSConfig setCodeLength(int codeLength) {
        this.codeLength = codeLength;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public FastSMSConfig setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }
}

