/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.backend.bdbje;

import com.fasterxml.storemate.backend.bdbje.BDBJEConfig;
import com.fasterxml.storemate.backend.bdbje.BDBJEStoreBackend;
import com.fasterxml.storemate.backend.bdbje.util.LastModKeyCreator;
import com.fasterxml.storemate.store.StoreConfig;
import com.fasterxml.storemate.store.backend.StoreBackendBuilder;
import com.fasterxml.storemate.store.backend.StoreBackendConfig;
import com.fasterxml.storemate.store.impl.StorableConverter;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.skife.config.DataAmount;

public class BDBJEBuilder
extends StoreBackendBuilder<BDBJEConfig> {
    protected StoreConfig _storeConfig;
    protected BDBJEConfig _bdbConfig;

    public BDBJEBuilder() {
        this(null, null);
    }

    public BDBJEBuilder(StoreConfig storeConfig, BDBJEConfig bdbConfig) {
        super(BDBJEConfig.class);
        this._storeConfig = storeConfig;
        this._bdbConfig = bdbConfig;
    }

    public BDBJEStoreBackend build() {
        return this.buildCreateAndInit();
    }

    public BDBJEStoreBackend buildCreateAndInit() {
        return this._buildAndInit(true, true);
    }

    public BDBJEStoreBackend buildAndInitReadOnly() {
        return this._buildAndInit(false, false);
    }

    public BDBJEStoreBackend buildAndInitReadWrite() {
        return this._buildAndInit(false, true);
    }

    protected BDBJEStoreBackend _buildAndInit(boolean canCreate, boolean canWrite) {
        if (this._storeConfig == null) {
            throw new IllegalStateException("Missing StoreConfig");
        }
        if (this._bdbConfig == null) {
            throw new IllegalStateException("Missing BDBJEConfig");
        }
        File dbRoot = this._bdbConfig.dataRoot;
        if (dbRoot == null) {
            throw new IllegalStateException("Missing BDBJEConfig.dataRoot");
        }
        if (!dbRoot.exists() || !dbRoot.isDirectory()) {
            if (!canCreate) {
                throw new IllegalArgumentException("Directory '" + dbRoot.getAbsolutePath() + "' does not exist, not allowed to (try to) create");
            }
            if (!dbRoot.mkdirs()) {
                throw new IllegalArgumentException("Directory '" + dbRoot.getAbsolutePath() + "' did not exist: failed to create it");
            }
        }
        StorableConverter storableConv = this._storeConfig.createStorableConverter();
        Environment env = new Environment(dbRoot, this.envConfig(canCreate, canWrite));
        Database entryDB = env.openDatabase(null, "entryMetadata", this.dbConfig(env));
        SecondaryDatabase index = env.openSecondaryDatabase(null, "lastModIndex", entryDB, this.indexConfig(env));
        DataAmount cacheSize = this._bdbConfig.cacheSize;
        BDBJEStoreBackend physicalStore = new BDBJEStoreBackend(storableConv, dbRoot, entryDB, index, cacheSize.getNumberOfBytes());
        try {
            physicalStore.start();
        }
        catch (DatabaseException e) {
            throw new IllegalStateException("Failed to open StorableStore: " + e.getMessage(), e);
        }
        return physicalStore;
    }

    public BDBJEBuilder with(StoreConfig config) {
        this._storeConfig = config;
        return this;
    }

    public BDBJEBuilder with(StoreBackendConfig config) {
        if (!(config instanceof BDBJEConfig)) {
            String desc = config == null ? "NULL" : config.getClass().getName();
            throw new IllegalArgumentException("BDB-JE must be configured with a BDBJEConfig instance, not " + desc);
        }
        this._bdbConfig = (BDBJEConfig)config;
        return this;
    }

    protected EnvironmentConfig envConfig(boolean allowCreate, boolean writeAccess) {
        EnvironmentConfig config = new EnvironmentConfig();
        config.setAllowCreate(allowCreate);
        config.setReadOnly(!writeAccess);
        config.setSharedCache(false);
        config.setCacheSize(this._bdbConfig.cacheSize.getNumberOfBytes());
        config.setLockTimeout(5000L, TimeUnit.MILLISECONDS);
        config.setConfigParam("je.lock.nLockTables", "7");
        return config;
    }

    protected DatabaseConfig dbConfig(Environment env) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        EnvironmentConfig econfig = env.getConfig();
        dbConfig.setReadOnly(econfig.getReadOnly());
        dbConfig.setAllowCreate(econfig.getAllowCreate());
        dbConfig.setSortedDuplicates(false);
        return dbConfig;
    }

    protected SecondaryConfig indexConfig(Environment env) {
        LastModKeyCreator keyCreator = new LastModKeyCreator();
        SecondaryConfig config = new SecondaryConfig();
        config.setAllowCreate(env.getConfig().getAllowCreate());
        config.setAllowPopulate(false);
        config.setKeyCreator((SecondaryKeyCreator)keyCreator);
        config.setSortedDuplicates(true);
        config.setImmutableSecondaryKey(false);
        return config;
    }
}

