/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.backend.bdbje;

import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.shared.util.WithBytesCallback;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.StoreException;
import com.fasterxml.storemate.store.backend.IterationAction;
import com.fasterxml.storemate.store.backend.IterationResult;
import com.fasterxml.storemate.store.backend.StorableIterationCallback;
import com.fasterxml.storemate.store.backend.StorableLastModIterationCallback;
import com.fasterxml.storemate.store.backend.StoreBackend;
import com.fasterxml.storemate.store.impl.StorableConverter;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import java.io.File;
import java.io.IOException;

public class BDBJEStoreBackend
extends StoreBackend {
    private final BDBConverter BDB_CONV = new BDBConverter();
    protected final File _dataRoot;
    protected final Database _entries;
    protected final SecondaryDatabase _index;

    public BDBJEStoreBackend(StorableConverter conv, File dbRoot, Database entryDB, SecondaryDatabase lastModIndex, long bdbCacheSize) {
        super(conv);
        this._dataRoot = dbRoot;
        this._entries = entryDB;
        this._index = lastModIndex;
    }

    public void start() {
    }

    public void stop() {
        Environment env = this._entries.getEnvironment();
        this._index.close();
        this._entries.close();
        env.close();
    }

    public long getEntryCount() {
        return this._entries.count();
    }

    public long getIndexedCount() {
        return this._entries.count();
    }

    public boolean hasEntry(StorableKey key) {
        OperationStatus status = this._entries.get(null, this.dbKey(key), new DatabaseEntry(), null);
        switch (status) {
            case SUCCESS: 
            case KEYEXIST: {
                return true;
            }
        }
        return false;
    }

    public Storable findEntry(StorableKey key) throws StoreException {
        DatabaseEntry result = new DatabaseEntry();
        OperationStatus status = this._entries.get(null, this.dbKey(key), result, null);
        if (status != OperationStatus.SUCCESS) {
            return null;
        }
        return this._storableConverter.decode(key, result.getData());
    }

    public Storable createEntry(StorableKey key, Storable storable) throws IOException, StoreException {
        DatabaseEntry dbKey = this.dbKey(key);
        OperationStatus status = this._entries.putNoOverwrite(null, dbKey, this.dbValue(storable));
        if (status == OperationStatus.SUCCESS) {
            return null;
        }
        if (status != OperationStatus.KEYEXIST) {
            throw new StoreException.Internal(key, "Internal error, strange return value for 'putNoOverwrite()': " + status);
        }
        DatabaseEntry result = new DatabaseEntry();
        status = this._entries.get(null, dbKey, result, null);
        if (status != OperationStatus.SUCCESS) {
            throw new StoreException.Internal(key, "Internal error, failed to access old value, status: " + status);
        }
        return this._storableConverter.decode(key, result.getData());
    }

    public Storable putEntry(StorableKey key, Storable storable) throws IOException, StoreException {
        DatabaseEntry result;
        DatabaseEntry dbKey = this.dbKey(key);
        OperationStatus status = this._entries.get(null, dbKey, result = new DatabaseEntry(), null);
        if (status != OperationStatus.SUCCESS) {
            result = null;
        }
        if ((status = this._entries.put(null, dbKey, this.dbValue(storable))) != OperationStatus.SUCCESS) {
            throw new StoreException.Internal(key, "Failed to put entry, OperationStatus=" + status);
        }
        if (result == null) {
            return null;
        }
        return this._storableConverter.decode(key, result.getData());
    }

    public void ovewriteEntry(StorableKey key, Storable storable) throws IOException, StoreException {
        OperationStatus status = this._entries.put(null, this.dbKey(key), this.dbValue(storable));
        if (status != OperationStatus.SUCCESS) {
            throw new StoreException.Internal(key, "Failed to overwrite entry, OperationStatus=" + status);
        }
    }

    public boolean deleteEntry(StorableKey key) throws IOException, StoreException {
        OperationStatus status = this._entries.delete(null, this.dbKey(key));
        switch (status) {
            case SUCCESS: {
                return true;
            }
            case NOTFOUND: {
                return false;
            }
        }
        throw new StoreException.Internal(key, "Internal error, failed to delete entry, OperationStatus=" + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IterationResult scanEntries(StorableIterationCallback cb) throws StoreException {
        DiskOrderedCursorConfig config = new DiskOrderedCursorConfig();
        DiskOrderedCursor crsr = this._entries.openCursor(config);
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try {
            block10: while (crsr.getNext(keyEntry, data, null) == OperationStatus.SUCCESS) {
                StorableKey key = this.storableKey(keyEntry);
                switch (cb.verifyKey(key)) {
                    case SKIP_ENTRY: {
                        continue block10;
                    }
                    case PROCESS_ENTRY: {
                        break;
                    }
                    case TERMINATE_ITERATION: {
                        IterationResult iterationResult = IterationResult.TERMINATED_FOR_KEY;
                        return iterationResult;
                    }
                }
                Storable entry = this._storableConverter.decode(key, data.getData());
                if (cb.processEntry(entry) != IterationAction.TERMINATE_ITERATION) continue;
                IterationResult iterationResult = IterationResult.TERMINATED_FOR_ENTRY;
                return iterationResult;
            }
            IterationResult iterationResult = IterationResult.FULLY_ITERATED;
            return iterationResult;
        }
        finally {
            crsr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IterationResult iterateEntriesByKey(StorableIterationCallback cb, StorableKey firstKey) throws StoreException {
        OperationStatus status;
        DatabaseEntry keyEntry;
        CursorConfig config = new CursorConfig();
        Cursor crsr = this._entries.openCursor(null, config);
        DatabaseEntry data = new DatabaseEntry();
        if (firstKey == null) {
            keyEntry = new DatabaseEntry();
            status = crsr.getFirst(keyEntry, data, null);
        } else {
            keyEntry = this.dbKey(firstKey);
            status = crsr.getSearchKeyRange(keyEntry, data, null);
        }
        try {
            while (status == OperationStatus.SUCCESS) {
                block14: {
                    StorableKey key = this.storableKey(keyEntry);
                    switch (cb.verifyKey(key)) {
                        case SKIP_ENTRY: {
                            break block14;
                        }
                        case PROCESS_ENTRY: {
                            break;
                        }
                        case TERMINATE_ITERATION: {
                            IterationResult iterationResult = IterationResult.TERMINATED_FOR_KEY;
                            return iterationResult;
                        }
                    }
                    Storable entry = this._storableConverter.decode(key, data.getData());
                    if (cb.processEntry(entry) == IterationAction.TERMINATE_ITERATION) {
                        IterationResult iterationResult = IterationResult.TERMINATED_FOR_ENTRY;
                        return iterationResult;
                    }
                }
                status = crsr.getNext(keyEntry, data, null);
            }
            IterationResult iterationResult = IterationResult.FULLY_ITERATED;
            return iterationResult;
        }
        finally {
            crsr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IterationResult iterateEntriesByModifiedTime(StorableLastModIterationCallback cb, long firstTimestamp) throws StoreException {
        OperationStatus status;
        DatabaseEntry keyEntry;
        if (cb == null) {
            throw new IllegalArgumentException("Can not pass null 'cb' argument");
        }
        CursorConfig config = new CursorConfig();
        SecondaryCursor crsr = this._index.openCursor(null, config);
        DatabaseEntry primaryKeyEntry = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        if (firstTimestamp <= 0L) {
            keyEntry = new DatabaseEntry();
            status = crsr.getFirst(keyEntry, primaryKeyEntry, data, null);
        } else {
            keyEntry = this.timestampKey(firstTimestamp);
            status = crsr.getSearchKeyRange(keyEntry, primaryKeyEntry, data, null);
        }
        try {
            while (status == OperationStatus.SUCCESS) {
                block21: {
                    long timestamp = BDBJEStoreBackend._getLongBE(keyEntry.getData(), 0);
                    switch (cb.verifyTimestamp(timestamp)) {
                        case SKIP_ENTRY: {
                            break block21;
                        }
                        case PROCESS_ENTRY: {
                            break;
                        }
                        case TERMINATE_ITERATION: {
                            IterationResult iterationResult = IterationResult.TERMINATED_FOR_TIMESTAMP;
                            return iterationResult;
                        }
                    }
                    StorableKey key = this.storableKey(primaryKeyEntry);
                    switch (cb.verifyKey(key)) {
                        case SKIP_ENTRY: {
                            break block21;
                        }
                        case PROCESS_ENTRY: {
                            break;
                        }
                        case TERMINATE_ITERATION: {
                            IterationResult iterationResult = IterationResult.TERMINATED_FOR_KEY;
                            return iterationResult;
                        }
                    }
                    Storable entry = this._storableConverter.decode(key, data.getData());
                    if (cb.processEntry(entry) == IterationAction.TERMINATE_ITERATION) {
                        IterationResult iterationResult = IterationResult.TERMINATED_FOR_ENTRY;
                        return iterationResult;
                    }
                }
                status = crsr.getNext(keyEntry, primaryKeyEntry, data, null);
            }
            IterationResult iterationResult = IterationResult.FULLY_ITERATED;
            return iterationResult;
        }
        finally {
            crsr.close();
        }
    }

    protected DatabaseEntry dbKey(StorableKey key) {
        return (DatabaseEntry)key.with((WithBytesCallback)this.BDB_CONV);
    }

    protected DatabaseEntry dbValue(Storable storable) {
        return (DatabaseEntry)storable.withRaw((WithBytesCallback)this.BDB_CONV);
    }

    protected StorableKey storableKey(DatabaseEntry entry) {
        return new StorableKey(entry.getData());
    }

    protected DatabaseEntry timestampKey(long timestamp) {
        byte[] raw = new byte[8];
        BDBJEStoreBackend._putIntBE(raw, 0, (int)(timestamp >> 32));
        BDBJEStoreBackend._putIntBE(raw, 4, (int)timestamp);
        return new DatabaseEntry(raw);
    }

    private static final void _putIntBE(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)(value >> 24);
        buffer[++offset] = (byte)(value >> 16);
        buffer[++offset] = (byte)(value >> 8);
        buffer[++offset] = (byte)value;
    }

    private static final long _getLongBE(byte[] buffer, int offset) {
        long l1 = BDBJEStoreBackend._getIntBE(buffer, offset);
        long l2 = BDBJEStoreBackend._getIntBE(buffer, offset + 4);
        return l1 << 32 | l2 << 32 >>> 32;
    }

    private static final int _getIntBE(byte[] buffer, int offset) {
        return buffer[offset] << 24 | (buffer[++offset] & 0xFF) << 16 | (buffer[++offset] & 0xFF) << 8 | buffer[++offset] & 0xFF;
    }

    private static final class BDBConverter
    implements WithBytesCallback<DatabaseEntry> {
        private BDBConverter() {
        }

        public DatabaseEntry withBytes(byte[] buffer, int offset, int length) {
            if (offset == 0 && length == buffer.length) {
                return new DatabaseEntry(buffer);
            }
            return new DatabaseEntry(buffer, offset, length);
        }
    }
}

