/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.exchange;

import com.fasterxml.jackson.databind.JsonNode;
import com.fastjrun.common.ClientException;
import com.fastjrun.common.CodeMsgConstants;
import com.fastjrun.common.CodeMsgI;
import com.fastjrun.common.exchange.BaseHTTPResponseDecoder;
import java.io.IOException;

public class DefaultHTTPResponseDecoder
extends BaseHTTPResponseDecoder {
    protected JsonNode parseBodyFromResponse(String responseResult) {
        JsonNode responseJsonObject;
        try {
            responseJsonObject = this.objectMapper.readTree(responseResult);
        }
        catch (IOException e) {
            throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.ClIENT_RESPONSE_NOT_VALID);
        }
        JsonNode headNode = responseJsonObject.get("head");
        if (headNode == null) {
            throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.CLIENT_RESPONSE_HEAD_NULL);
        }
        JsonNode codeNode = headNode.get("code");
        if (codeNode == null) {
            throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.CLIENT_RESPONSE_HEAD_CODE_NULL);
        }
        String code = codeNode.asText();
        if (code.equals("")) {
            throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.CLIENT_RESPONSE_HEAD_CODE_EMPTY);
        }
        if (code.equals("0000")) {
            return responseJsonObject.get("body");
        }
        JsonNode msgNode = headNode.get("msg");
        if (msgNode == null) {
            throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.ClIENT_RESPONSE_HEAD_MSG_NULL);
        }
        String msg = msgNode.asText();
        if (msg.equals("")) {
            throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.ClIENT_RESPONSE_HEAD_MSG_EMPTY);
        }
        this.log.warn("code = {},msg = {}", (Object)code, (Object)msg);
        throw new ClientException(code, msg);
    }
}

