/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.exchange;

import com.fastjrun.apibase.dto.BasePacket;
import com.fastjrun.apibase.dto.DefaultResponseHead;
import com.fastjrun.common.ClientException;
import com.fastjrun.common.CodeMsgConstants;
import com.fastjrun.common.CodeMsgI;
import com.fastjrun.common.exchange.BaseRPCResponseDecoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DefaultRPCResponseDecoder
extends BaseRPCResponseDecoder {
    protected <T> void parseResponseHead(T head) {
        DefaultResponseHead defaultResponseHead = (DefaultResponseHead)head;
        String code = defaultResponseHead.getCode();
        if (!code.equals("0000")) {
            String msg = defaultResponseHead.getMsg();
            if (msg == null) {
                throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.ClIENT_RESPONSE_HEAD_MSG_NULL);
            }
            if (msg.equals("")) {
                throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.ClIENT_RESPONSE_HEAD_MSG_EMPTY);
            }
            this.log.warn("code = {},msg = {}", (Object)code, (Object)msg);
            throw new ClientException(code, msg);
        }
    }

    protected Object parseDataFromResponse(Object response) {
        BasePacket baseResponse = (BasePacket)response;
        this.parseResponseHead(baseResponse.getHead());
        try {
            Method method = response.getClass().getMethod("getBody", new Class[0]);
            return method.invoke(response, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClientException((CodeMsgI)CodeMsgConstants.CodeMsg.ClIENT_NETWORK_RESPONSE_NOT_OK);
        }
    }
}

