/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.common.helper;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;

public class LocalDateTimeHelper {
    public static final String YYYY = "yyyy";
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHH = "yyyyMMddHH";
    public static final String YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH = "yyyy-MM-dd HH";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String BASE_TIME_FORMAT = "[yyyyMMddHHmmss][yyyyMMddHHmm][yyyyMMddHH][yyyyMMdd][yyyyMM][yyyy][[-][/][.]MM][[-][/][.]dd][ ][HH][[:][.]mm][[:][.]ss][[:][.]SSS]";

    public static String format(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parse(String timeString) {
        return LocalDateTime.parse(timeString, LocalDateTimeHelper.getDateTimeFormatterByPattern(BASE_TIME_FORMAT));
    }

    public static LocalDateTime parseByPattern(String timeString, String pattern) {
        return LocalDateTime.parse(timeString, LocalDateTimeHelper.getDateTimeFormatterByPattern(pattern));
    }

    private static DateTimeFormatter getDateTimeFormatterByPattern(String pattern) {
        return new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.YEAR_OF_ERA, LocalDateTime.now().getYear()).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter();
    }

    public static LocalDate toLocalDate(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate();
    }

    public static LocalDateTime fromLocalDate(LocalDate localDate) {
        return localDate.atStartOfDay();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime fromDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static long toTimestamp(LocalDateTime localDateTime) {
        return LocalDateTimeHelper.toInstant(localDateTime).toEpochMilli();
    }

    public static LocalDateTime fromTimestamp(long timestamp) {
        return LocalDateTimeHelper.fromInstant(Instant.ofEpochMilli(timestamp));
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static LocalDateTime fromInstant(Instant instant) {
        return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime atStartOfSecond(LocalDateTime localDateTime) {
        return localDateTime.withNano(0);
    }

    public static LocalDateTime atStartOfMinute(LocalDateTime localDateTime) {
        return LocalDateTimeHelper.atStartOfSecond(localDateTime).withSecond(0);
    }

    public static LocalDateTime atStartOfHour(LocalDateTime localDateTime) {
        return LocalDateTimeHelper.atStartOfMinute(localDateTime).withMinute(0);
    }

    public static LocalDateTime atStartOfDay(LocalDateTime localDateTime) {
        return LocalDateTimeHelper.atStartOfHour(localDateTime).withHour(0);
    }

    public static LocalDateTime atStartOfWeek(LocalDateTime localDateTime) {
        return LocalDateTimeHelper.atStartOfDay(localDateTime).minusDays(localDateTime.getDayOfWeek().getValue() - 1);
    }

    public static LocalDateTime atStartOfMonth(LocalDateTime localDateTime) {
        return LocalDateTimeHelper.atStartOfDay(localDateTime).withDayOfMonth(1);
    }

    public static LocalDateTime atStartOfYear(LocalDateTime localDateTime) {
        return LocalDateTimeHelper.atStartOfMonth(localDateTime).withMonth(1);
    }

    public static String formatDuration(LocalDateTime startTime, LocalDateTime endTime) {
        long second;
        long minute;
        long hour;
        if (startTime.compareTo(endTime) > 0) {
            return "\u51fa\u9519\u5566 ! \u8d77\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4";
        }
        Duration duration = Duration.between(startTime, endTime);
        StringBuilder output = new StringBuilder();
        long day = duration.toDays();
        if (day > 0L) {
            output.append(day).append(" \u5929 ");
            duration = duration.minusDays(day);
        }
        if ((hour = duration.toHours()) > 0L) {
            output.append(hour).append(" \u5c0f\u65f6 ");
            duration = duration.minusHours(hour);
        }
        if ((minute = duration.toMinutes()) > 0L) {
            output.append(minute).append(" \u5206 ");
            duration = duration.minusMinutes(minute);
        }
        if ((second = duration.getSeconds()) > 0L) {
            output.append(second).append(" \u79d2 ");
            duration = duration.minusSeconds(second);
        }
        output.append(duration.toMillis()).append(" \u6beb\u79d2");
        return output.toString();
    }

    public static class builder {
        private LocalDateTime builderTime;

        public builder() {
            this.builderTime = LocalDateTime.now();
        }

        public builder(LocalDateTime localDateTime) {
            this.builderTime = localDateTime;
        }

        public static builder now() {
            return new builder();
        }

        public static builder parse(String timeString) {
            return new builder(LocalDateTime.parse(timeString, LocalDateTimeHelper.getDateTimeFormatterByPattern(LocalDateTimeHelper.BASE_TIME_FORMAT)));
        }

        public static builder parseByPattern(String timeString, String pattern) {
            return new builder(LocalDateTime.parse(timeString, LocalDateTimeHelper.getDateTimeFormatterByPattern(pattern)));
        }

        public static builder fromLocalDate(LocalDate localDate) {
            return new builder(localDate.atStartOfDay());
        }

        public static builder fromDate(Date date) {
            return new builder(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        }

        public static builder fromTimestamp(long timestamp) {
            return new builder(LocalDateTimeHelper.fromInstant(Instant.ofEpochMilli(timestamp)));
        }

        public static builder fromInstant(Instant instant) {
            return new builder(instant.atZone(ZoneId.systemDefault()).toLocalDateTime());
        }

        public builder withYear(int year) {
            this.builderTime = this.builderTime.withYear(year);
            return this;
        }

        public builder withMonth(int month) {
            this.builderTime = this.builderTime.withMonth(month);
            return this;
        }

        public builder withDayOfMonth(int dayOfMonth) {
            this.builderTime = this.builderTime.withDayOfMonth(dayOfMonth);
            return this;
        }

        public builder withDayOfYear(int dayOfYear) {
            this.builderTime = this.builderTime.withDayOfYear(dayOfYear);
            return this;
        }

        public builder withHour(int hour) {
            this.builderTime = this.builderTime.withHour(hour);
            return this;
        }

        public builder withMinute(int minute) {
            this.builderTime = this.builderTime.withMinute(minute);
            return this;
        }

        public builder withSecond(int second) {
            this.builderTime = this.builderTime.withSecond(second);
            return this;
        }

        public builder withNano(int nanoOfSecond) {
            this.builderTime = this.builderTime.withNano(nanoOfSecond);
            return this;
        }

        public builder plusYears(long years) {
            this.builderTime = this.builderTime.plusYears(years);
            return this;
        }

        public builder plusMonths(long months) {
            this.builderTime = this.builderTime.plusMonths(months);
            return this;
        }

        public builder plusWeeks(long weeks) {
            this.builderTime = this.builderTime.plusWeeks(weeks);
            return this;
        }

        public builder plusDays(long days) {
            this.builderTime = this.builderTime.plusDays(days);
            return this;
        }

        public builder plusHours(long hours) {
            this.builderTime = this.builderTime.plusHours(hours);
            return this;
        }

        public builder plusMinutes(long minutes) {
            this.builderTime = this.builderTime.plusMinutes(minutes);
            return this;
        }

        public builder plusSeconds(long seconds) {
            this.builderTime = this.builderTime.plusSeconds(seconds);
            return this;
        }

        public builder plusNanos(long nanos) {
            this.builderTime = this.builderTime.plusNanos(nanos);
            return this;
        }

        public builder minusYears(long years) {
            this.builderTime = this.builderTime.minusYears(years);
            return this;
        }

        public builder minusMonths(long months) {
            this.builderTime = this.builderTime.minusMonths(months);
            return this;
        }

        public builder minusWeeks(long weeks) {
            this.builderTime = this.builderTime.minusWeeks(weeks);
            return this;
        }

        public builder minusDays(long days) {
            this.builderTime = this.builderTime.minusDays(days);
            return this;
        }

        public builder minusHours(long hours) {
            this.builderTime = this.builderTime.minusHours(hours);
            return this;
        }

        public builder minusMinutes(long minutes) {
            this.builderTime = this.builderTime.minusMinutes(minutes);
            return this;
        }

        public builder minusSeconds(long seconds) {
            this.builderTime = this.builderTime.minusSeconds(seconds);
            return this;
        }

        public builder minusNanos(long nanos) {
            this.builderTime = this.builderTime.minusNanos(nanos);
            return this;
        }

        public builder atStartOfSecond() {
            this.builderTime = this.builderTime.withNano(0);
            return this;
        }

        public builder atStartOfMinute() {
            this.atStartOfSecond();
            this.builderTime = this.builderTime.withSecond(0);
            return this;
        }

        public builder atStartOfHour() {
            this.atStartOfMinute();
            this.builderTime = this.builderTime.withMinute(0);
            return this;
        }

        public builder atStartOfDay() {
            this.atStartOfHour();
            this.builderTime = this.builderTime.withHour(0);
            return this;
        }

        public builder atStartOfWeek() {
            this.atStartOfDay();
            this.builderTime = this.builderTime.minusDays(this.builderTime.getDayOfWeek().getValue() - 1);
            return this;
        }

        public builder atStartOfMonth() {
            this.atStartOfDay();
            this.builderTime = this.builderTime.withDayOfMonth(1);
            return this;
        }

        public builder atStartOfYear(LocalDateTime localDateTime) {
            this.atStartOfDay();
            this.builderTime = this.builderTime.withMonth(1);
            return this;
        }

        public String format(String pattern) {
            return LocalDateTimeHelper.format(this.builderTime, pattern);
        }

        public LocalDate toLocalDate() {
            return this.builderTime.toLocalDate();
        }

        public Date toDate() {
            return Date.from(this.builderTime.atZone(ZoneId.systemDefault()).toInstant());
        }

        public long toTimestamp() {
            return this.toInstant().toEpochMilli();
        }

        public Instant toInstant() {
            return this.builderTime.atZone(ZoneId.systemDefault()).toInstant();
        }

        public LocalDateTime build() {
            return this.builderTime;
        }
    }
}

