/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.test.base;

import com.fastjrun.test.util.TestUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

public abstract class AbstractTestNGTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Object> propParams = new HashMap<String, Object>();

    @BeforeClass
    @Parameters(value={"envName"})
    protected void initParam(@Optional(value="unitTest") String envName) {
        this.log.debug("initParam");
        try {
            this.propParams = TestUtils.initParam("/testdata/" + envName + ".yaml");
        }
        catch (IOException e) {
            this.log.error("load config for error:{}", (Throwable)e);
        }
    }

    @DataProvider(name="loadParam")
    public Object[][] loadParam(Method method) {
        this.log.debug("loadParam");
        return TestUtils.loadParam(this.propParams, this.getClass().getSimpleName(), method);
    }
}

