/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.client;

import com.fastjrun.common.client.BaseHTTPClient;
import com.fastjrun.common.util.DefaultHTTPUtilClient;
import com.fastjrun.exchange.DefaultHTTPExchange;
import com.fastjrun.helper.EncryptHelper;
import java.util.HashMap;
import java.util.ResourceBundle;

public class DefaultHTTPApiClient
extends BaseHTTPClient<DefaultHTTPUtilClient, DefaultHTTPExchange> {
    protected String accessKey;
    protected String accessKeySn;

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessKeySn() {
        return this.accessKeySn;
    }

    public void setAccessKeySn(String accessKeySn) {
        this.accessKeySn = accessKeySn;
    }

    public DefaultHTTPApiClient() {
        this.baseClient = new DefaultHTTPUtilClient();
        this.baseExchange = new DefaultHTTPExchange();
    }

    protected void initUtilClient(String baseUrl) {
        ((DefaultHTTPUtilClient)this.baseClient).setBaseUrl(baseUrl);
        HashMap<String, String> requestHeaderDefault = new HashMap<String, String>();
        requestHeaderDefault.put("Content-Type", "application/json;charset=UTF-8");
        ((DefaultHTTPUtilClient)this.baseClient).setRequestHeaderDefault(requestHeaderDefault);
    }

    public void initSDKConfig() {
        ResourceBundle rb = ResourceBundle.getBundle("api-sdk");
        String baseUrl = rb.getString("apiServer.baseUrl");
        this.accessKey = rb.getString("apiServer.accessKey");
        this.accessKeySn = rb.getString("apiServer.accessKeySn");
        this.initUtilClient(baseUrl);
    }

    protected String generateUrlSuffix() {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(this.accessKey);
        long txTime = System.currentTimeMillis();
        sb.append("/").append(txTime);
        try {
            String md5Hash = EncryptHelper.md5Digest((String)(this.getAccessKeySn() + txTime));
            sb.append("/").append(md5Hash);
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return sb.toString();
    }
}

