/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.client;

import com.fastjrun.common.client.BaseHTTPClient;
import com.fastjrun.common.util.DefaultHTTPUtilClient;
import com.fastjrun.exchange.DefaultHTTPExchange;
import java.util.HashMap;
import java.util.ResourceBundle;

public class DefaultHTTPAppClient
extends BaseHTTPClient<DefaultHTTPUtilClient, DefaultHTTPExchange> {
    protected String appSource;
    protected String appVersion;
    protected String deviceId;
    protected String appKey;

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSource() {
        return this.appSource;
    }

    public void setAppSource(String appSource) {
        this.appSource = appSource;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public DefaultHTTPAppClient() {
        this.baseClient = new DefaultHTTPUtilClient();
        this.baseExchange = new DefaultHTTPExchange();
    }

    protected void initUtilClient(String baseUrl) {
        ((DefaultHTTPUtilClient)this.baseClient).setBaseUrl(baseUrl);
        HashMap<String, String> requestHeaderDefault = new HashMap<String, String>();
        requestHeaderDefault.put("Content-Type", "application/json;charset=UTF-8");
        ((DefaultHTTPUtilClient)this.baseClient).setRequestHeaderDefault(requestHeaderDefault);
    }

    public void initSDKConfig() {
        ResourceBundle rb = ResourceBundle.getBundle("api-sdk");
        String baseUrl = rb.getString("appServer.baseUrl");
        this.appKey = rb.getString("appServer.appKey");
        this.appVersion = rb.getString("appServer.appVersion");
        this.appSource = rb.getString("appServer.appSource");
        this.deviceId = rb.getString("appServer.deviceId");
        this.initUtilClient(baseUrl);
    }

    protected String generateUrlSuffix() {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(this.appKey);
        sb.append("/").append(this.appVersion);
        sb.append("/").append(this.appSource);
        sb.append("/").append(this.deviceId);
        long txTime = System.currentTimeMillis();
        sb.append("/").append(txTime);
        return sb.toString();
    }
}

